/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Locale;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.SqlKind;

public class TimeExtractionFunction
implements ExtractionFunction {
    private static final ImmutableSet<TimeUnitRange> VALID_TIME_EXTRACT = Sets.immutableEnumSet((Enum)TimeUnitRange.YEAR, (Enum[])new TimeUnitRange[]{TimeUnitRange.MONTH, TimeUnitRange.DAY, TimeUnitRange.WEEK});
    private static final String ISO_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private final String format;
    private final String granularity;
    private final String timeZone;
    private final String local;

    public TimeExtractionFunction(String format, String granularity, String timeZone, String local) {
        this.format = format;
        this.granularity = granularity;
        this.timeZone = timeZone;
        this.local = local;
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "timeFormat");
        DruidQuery.writeFieldIf(generator, "format", this.format);
        DruidQuery.writeFieldIf(generator, "granularity", this.granularity);
        DruidQuery.writeFieldIf(generator, "timeZone", this.timeZone);
        DruidQuery.writeFieldIf(generator, "locale", this.local);
        generator.writeEndObject();
    }

    public static TimeExtractionFunction createDefault(String timeZone) {
        return new TimeExtractionFunction(ISO_TIME_FORMAT, null, timeZone, null);
    }

    public static TimeExtractionFunction createExtractFromGranularity(Granularity granularity, String timeZone) {
        switch (granularity) {
            case DAY: {
                return new TimeExtractionFunction("d", null, timeZone, Locale.getDefault().toLanguageTag());
            }
            case MONTH: {
                return new TimeExtractionFunction("M", null, timeZone, Locale.getDefault().toLanguageTag());
            }
            case YEAR: {
                return new TimeExtractionFunction("yyyy", null, timeZone, Locale.getDefault().toLanguageTag());
            }
            case WEEK: {
                return new TimeExtractionFunction("w", null, timeZone, Locale.getDefault().toLanguageTag());
            }
        }
        throw new IllegalArgumentException("Granularity [" + (Object)((Object)granularity) + "] is not supported");
    }

    public static TimeExtractionFunction createFloorFromGranularity(Granularity granularity, String timeZone) {
        return new TimeExtractionFunction(ISO_TIME_FORMAT, granularity.value, timeZone, Locale.getDefault().toLanguageTag());
    }

    public static boolean isValidTimeExtract(RexCall call) {
        if (call.getKind() != SqlKind.EXTRACT) {
            return false;
        }
        RexLiteral flag = (RexLiteral)call.operands.get(0);
        TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
        return timeUnit != null && VALID_TIME_EXTRACT.contains((Object)timeUnit);
    }
}

