/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.adapter.druid.Granularities;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.adapter.druid.TimeExtractionFunction;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;

public class DruidDateTimeUtils {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    private DruidDateTimeUtils() {
    }

    @Nullable
    public static List<Interval> createInterval(RexNode e) {
        List<Range<Long>> ranges = DruidDateTimeUtils.extractRanges(e, false);
        if (ranges == null) {
            return null;
        }
        TreeRangeSet condensedRanges = TreeRangeSet.create();
        for (Range<Long> r : ranges) {
            condensedRanges.add(r);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inferred ranges on interval : " + condensedRanges);
        }
        return DruidDateTimeUtils.toInterval((List<Range<Long>>)ImmutableList.copyOf((Collection)condensedRanges.asRanges()));
    }

    protected static List<Interval> toInterval(List<Range<Long>> ranges) {
        List intervals = Lists.transform(ranges, range -> {
            long end;
            if (!range.hasLowerBound() && !range.hasUpperBound()) {
                return DruidTable.DEFAULT_INTERVAL;
            }
            long start = range.hasLowerBound() ? ((Long)range.lowerEndpoint()).longValue() : DruidTable.DEFAULT_INTERVAL.getStartMillis();
            long l = end = range.hasUpperBound() ? ((Long)range.upperEndpoint()).longValue() : DruidTable.DEFAULT_INTERVAL.getEndMillis();
            if (range.hasLowerBound() && range.lowerBoundType() == BoundType.OPEN) {
                ++start;
            }
            if (range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED) {
                ++end;
            }
            return new Interval(start, end, (Chronology)ISOChronology.getInstanceUTC());
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Converted time ranges " + ranges + " to interval " + intervals);
        }
        return intervals;
    }

    @Nullable
    protected static List<Range<Long>> extractRanges(RexNode node, boolean withNot) {
        switch (node.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case BETWEEN: 
            case IN: {
                return DruidDateTimeUtils.leafToRanges((RexCall)node, withNot);
            }
            case NOT: {
                return DruidDateTimeUtils.extractRanges((RexNode)((RexCall)node).getOperands().get(0), !withNot);
            }
            case OR: {
                RexCall call = (RexCall)node;
                ArrayList<Range<Long>> intervals = new ArrayList<Range<Long>>();
                for (RexNode child : call.getOperands()) {
                    List<Range<Long>> extracted = DruidDateTimeUtils.extractRanges(child, withNot);
                    if (extracted == null) continue;
                    intervals.addAll(extracted);
                }
                return intervals;
            }
            case AND: {
                RexCall call = (RexCall)node;
                ArrayList<Object> ranges = new ArrayList<Range<Long>>();
                for (RexNode child : call.getOperands()) {
                    List<Range<Long>> extractedRanges = DruidDateTimeUtils.extractRanges(child, false);
                    if (extractedRanges == null || extractedRanges.isEmpty()) {
                        return null;
                    }
                    if (ranges.isEmpty()) {
                        ranges.addAll(extractedRanges);
                        continue;
                    }
                    ArrayList<Range> overlapped = new ArrayList<Range>();
                    for (Range range : ranges) {
                        for (Range<Long> interval : extractedRanges) {
                            if (!range.isConnected(interval)) continue;
                            overlapped.add(range.intersection(interval));
                        }
                    }
                    ranges = overlapped;
                }
                return ranges;
            }
        }
        return null;
    }

    @Nullable
    protected static List<Range<Long>> leafToRanges(RexCall call, boolean withNot) {
        switch (call.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                Long value;
                if (call.getOperands().get(0) instanceof RexInputRef && DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(1)) != null) {
                    value = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(1));
                } else if (call.getOperands().get(1) instanceof RexInputRef && DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(0)) != null) {
                    value = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(0));
                } else {
                    return null;
                }
                switch (call.getKind()) {
                    case LESS_THAN: {
                        return ImmutableList.of((Object)(withNot ? Range.atLeast((Comparable)value) : Range.lessThan((Comparable)value)));
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return ImmutableList.of((Object)(withNot ? Range.greaterThan((Comparable)value) : Range.atMost((Comparable)value)));
                    }
                    case GREATER_THAN: {
                        return ImmutableList.of((Object)(withNot ? Range.atMost((Comparable)value) : Range.greaterThan((Comparable)value)));
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return ImmutableList.of((Object)(withNot ? Range.lessThan((Comparable)value) : Range.atLeast((Comparable)value)));
                    }
                }
                if (!withNot) {
                    return ImmutableList.of((Object)Range.closed((Comparable)value, (Comparable)value));
                }
                return ImmutableList.of((Object)Range.lessThan((Comparable)value), (Object)Range.greaterThan((Comparable)value));
            }
            case BETWEEN: {
                boolean inverted;
                if (DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(2)) == null || DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(3)) == null) {
                    return null;
                }
                Long value1 = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(2));
                Long value2 = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(3));
                boolean bl = inverted = value1.compareTo(value2) > 0;
                if (!withNot) {
                    return ImmutableList.of((Object)(inverted ? Range.closed((Comparable)value2, (Comparable)value1) : Range.closed((Comparable)value1, (Comparable)value2)));
                }
                return ImmutableList.of((Object)Range.lessThan((Comparable)(inverted ? value2 : value1)), (Object)Range.greaterThan((Comparable)(inverted ? value1 : value2)));
            }
            case IN: {
                ImmutableList.Builder ranges = ImmutableList.builder();
                for (RexNode operand : Util.skip((List)call.operands)) {
                    Long element = DruidDateTimeUtils.literalValue(operand);
                    if (element == null) {
                        return null;
                    }
                    if (withNot) {
                        ranges.add((Object)Range.lessThan((Comparable)element));
                        ranges.add((Object)Range.greaterThan((Comparable)element));
                        continue;
                    }
                    ranges.add((Object)Range.closed((Comparable)element, (Comparable)element));
                }
                return ranges.build();
            }
        }
        return null;
    }

    @Nullable
    protected static Long literalValue(RexNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                switch (((RexLiteral)node).getTypeName()) {
                    case TIMESTAMP: 
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        TimestampString tsVal = (TimestampString)((RexLiteral)node).getValueAs(TimestampString.class);
                        if (tsVal == null) {
                            return null;
                        }
                        return tsVal.getMillisSinceEpoch();
                    }
                    case DATE: {
                        DateString dateVal = (DateString)((RexLiteral)node).getValueAs(DateString.class);
                        if (dateVal == null) {
                            return null;
                        }
                        return dateVal.getMillisSinceEpoch();
                    }
                }
                break;
            }
            case CAST: {
                assert (node instanceof RexCall);
                RexCall call = (RexCall)node;
                RexNode operand = (RexNode)call.getOperands().get(0);
                RelDataType callType = call.getType();
                RelDataType operandType = operand.getType();
                if (operand.getKind() != SqlKind.LITERAL || callType.getSqlTypeName() != operandType.getSqlTypeName() || callType.getSqlTypeName() != SqlTypeName.DATE && callType.getSqlTypeName() != SqlTypeName.TIMESTAMP && callType.getSqlTypeName() != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE || !callType.isNullable() || operandType.isNullable()) break;
                return DruidDateTimeUtils.literalValue(operand);
            }
        }
        return null;
    }

    @Nullable
    public static Granularity extractGranularity(RexNode node, String timeZone) {
        int valueIndex;
        int flagIndex;
        if (TimeExtractionFunction.isValidTimeExtract(node)) {
            flagIndex = 0;
            valueIndex = 1;
        } else if (TimeExtractionFunction.isValidTimeFloor(node)) {
            valueIndex = 0;
            flagIndex = 1;
        } else {
            return null;
        }
        RexCall call = (RexCall)node;
        RexNode value = (RexNode)call.operands.get(valueIndex);
        RexLiteral flag = (RexLiteral)call.operands.get(flagIndex);
        TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
        RelDataType valueType = value.getType();
        if (valueType.getSqlTypeName() == SqlTypeName.DATE || valueType.getSqlTypeName() == SqlTypeName.TIMESTAMP) {
            return Granularities.createGranularity(timeUnit, "UTC");
        }
        if (valueType.getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return Granularities.createGranularity(timeUnit, timeZone);
        }
        return null;
    }

    @Nullable
    public static String toISOPeriodFormat(Granularity.Type type) {
        switch (type) {
            case SECOND: {
                return Period.seconds((int)1).toString();
            }
            case MINUTE: {
                return Period.minutes((int)1).toString();
            }
            case HOUR: {
                return Period.hours((int)1).toString();
            }
            case DAY: {
                return Period.days((int)1).toString();
            }
            case WEEK: {
                return Period.weeks((int)1).toString();
            }
            case MONTH: {
                return Period.months((int)1).toString();
            }
            case QUARTER: {
                return Period.months((int)3).toString();
            }
            case YEAR: {
                return Period.years((int)1).toString();
            }
        }
        return null;
    }

    @Nullable
    public static Granularity.Type toDruidGranularity(TimeUnitRange timeUnit) {
        if (timeUnit == null) {
            return null;
        }
        switch (timeUnit) {
            case YEAR: {
                return Granularity.Type.YEAR;
            }
            case QUARTER: {
                return Granularity.Type.QUARTER;
            }
            case MONTH: {
                return Granularity.Type.MONTH;
            }
            case WEEK: {
                return Granularity.Type.WEEK;
            }
            case DAY: {
                return Granularity.Type.DAY;
            }
            case HOUR: {
                return Granularity.Type.HOUR;
            }
            case MINUTE: {
                return Granularity.Type.MINUTE;
            }
            case SECOND: {
                return Granularity.Type.SECOND;
            }
        }
        return null;
    }
}

