/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ahc.AhcBinding;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.component.ahc.DefaultAhcBinding;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AhcComponent
extends HeaderFilterStrategyComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AhcComponent.class);
    private static final String CLIENT_CONFIG_PREFIX = "clientConfig.";
    private static final String CLIENT_REALM_CONFIG_PREFIX = "realm.";
    private AsyncHttpClient client;
    private AsyncHttpClientConfig clientConfig;
    private AhcBinding binding;
    private SSLContextParameters sslContextParameters;
    private boolean allowJavaSerializedObject;

    public AhcComponent() {
        super(AhcEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String addressUri = this.createAddressUri(uri, remaining);
        AhcEndpoint endpoint = this.createAhcEndpoint(uri, this, null);
        this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        endpoint.setClient(this.getClient());
        endpoint.setClientConfig(this.getClientConfig());
        endpoint.setBinding(this.getBinding());
        endpoint.setSslContextParameters(this.getSslContextParameters());
        this.setProperties((Object)endpoint, parameters);
        if (IntrospectionSupport.hasProperties(parameters, (String)CLIENT_CONFIG_PREFIX)) {
            DefaultAsyncHttpClientConfig.Builder builder;
            DefaultAsyncHttpClientConfig.Builder builder2 = builder = endpoint.getClientConfig() == null ? new DefaultAsyncHttpClientConfig.Builder() : AhcComponent.cloneConfig(endpoint.getClientConfig());
            if (endpoint.getClient() != null) {
                LOG.warn("The user explicitly set an AsyncHttpClient instance on the component or endpoint, but this endpoint URI contains client configuration parameters.  Are you sure that this is what was intended?  The AsyncHttpClient will be used and the URI parameters will be ignored.");
            } else if (endpoint.getClientConfig() != null) {
                LOG.warn("The user explicitly set an AsyncHttpClientConfig instance on the component or endpoint, but this endpoint URI contains client configuration parameters.  Are you sure that this is what was intended?  The URI parameters will be applied to a clone of the supplied AsyncHttpClientConfig in order to prevent unintended modification of the explicitly configured AsyncHttpClientConfig.  That is, the URI parameters override the settings on the explicitly configured AsyncHttpClientConfig for this endpoint.");
            }
            Realm.Builder realmBuilder = null;
            if (IntrospectionSupport.hasProperties(parameters, (String)CLIENT_REALM_CONFIG_PREFIX)) {
                Map realmParams = IntrospectionSupport.extractProperties(parameters, (String)CLIENT_REALM_CONFIG_PREFIX);
                realmBuilder = new Realm.Builder(realmParams.get("realm.principal").toString(), realmParams.get("realm.password").toString());
                this.setProperties(realmBuilder, realmParams);
                this.validateParameters(uri, realmParams, null);
            }
            Map clientParams = IntrospectionSupport.extractProperties(parameters, (String)CLIENT_CONFIG_PREFIX);
            this.setProperties(builder, clientParams);
            this.validateParameters(uri, clientParams, null);
            if (realmBuilder != null) {
                builder.setRealm(realmBuilder.build());
            }
            endpoint.setClientConfig((AsyncHttpClientConfig)builder.build());
        }
        addressUri = UnsafeUriCharactersEncoder.encodeHttpURI((String)addressUri);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(addressUri), parameters);
        endpoint.setHttpUri(httpUri);
        return endpoint;
    }

    public AsyncHttpClient getClient() {
        return this.client;
    }

    public void setClient(AsyncHttpClient client) {
        this.client = client;
    }

    public AhcBinding getBinding() {
        if (this.binding == null) {
            this.binding = new DefaultAhcBinding();
        }
        return this.binding;
    }

    public void setBinding(AhcBinding binding) {
        this.binding = binding;
    }

    public AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isAllowJavaSerializedObject() {
        return this.allowJavaSerializedObject;
    }

    public void setAllowJavaSerializedObject(boolean allowJavaSerializedObject) {
        this.allowJavaSerializedObject = allowJavaSerializedObject;
    }

    protected String createAddressUri(String uri, String remaining) {
        return remaining;
    }

    protected AhcEndpoint createAhcEndpoint(String endpointUri, AhcComponent component, URI httpUri) {
        return new AhcEndpoint(endpointUri, component, httpUri);
    }

    static DefaultAsyncHttpClientConfig.Builder cloneConfig(AsyncHttpClientConfig clientConfig) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder(clientConfig);
        return builder;
    }
}

