/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AhcProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AhcProducer.class);
    private final AsyncHttpClient client;
    private ExecutorService workerPool;
    private boolean shutdownPool;

    public AhcProducer(AhcEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.client = endpoint.getOrCreateClient();
    }

    public AhcEndpoint getEndpoint() {
        return (AhcEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        if (this.workerPool == null) {
            this.workerPool = this.getEndpoint().getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "AhcWorkerPool");
            this.shutdownPool = true;
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.shutdownPool && this.workerPool != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdown(this.workerPool);
            this.workerPool = null;
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Request request = this.getEndpoint().getBinding().prepareRequest(this.getEndpoint(), exchange);
            LOG.debug("Executing request {}", (Object)request);
            this.client.executeRequest(request, (AsyncHandler)new AhcAsyncHandler(exchange, callback, request.getUrl(), this.getEndpoint().getBufferSize()));
            return false;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    private final class AhcAsyncHandler
    implements AsyncHandler<Exchange> {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final String url;
        private final ByteArrayOutputStream os;
        private int contentLength;
        private int statusCode;
        private String statusText;

        private AhcAsyncHandler(Exchange exchange, AsyncCallback callback, String url, int bufferSize) {
            this.exchange = exchange;
            this.callback = callback;
            this.url = url;
            this.os = new ByteArrayOutputStream(bufferSize);
        }

        public void onThrowable(Throwable t) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} onThrowable {}", new Object[]{this.exchange.getExchangeId(), t.getMessage(), t});
            }
            try {
                AhcProducer.this.getEndpoint().getBinding().onThrowable(AhcProducer.this.getEndpoint(), this.exchange, t);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            finally {
                AhcProducer.this.workerPool.execute((Runnable)this.callback);
            }
        }

        public Exchange onCompleted() throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} onCompleted", (Object)this.exchange.getExchangeId());
            }
            try {
                AhcProducer.this.getEndpoint().getBinding().onComplete(AhcProducer.this.getEndpoint(), this.exchange, this.url, this.os, this.contentLength, this.statusCode, this.statusText);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            finally {
                AhcProducer.this.workerPool.execute((Runnable)this.callback);
            }
            return this.exchange;
        }

        public String toString() {
            return "AhcAsyncHandler for exchangeId: " + this.exchange.getExchangeId() + " -> " + this.url;
        }

        public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            this.os.write(bodyPart.getBodyPartBytes());
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} onBodyPartReceived {} bytes", (Object)this.exchange.getExchangeId(), (Object)bodyPart.length());
            }
            this.contentLength += bodyPart.length();
            return AsyncHandler.State.CONTINUE;
        }

        public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} onStatusReceived {}", (Object)this.exchange.getExchangeId(), (Object)responseStatus);
            }
            try {
                this.statusCode = responseStatus.getStatusCode();
                this.statusText = responseStatus.getStatusText();
                AhcProducer.this.getEndpoint().getBinding().onStatusReceived(AhcProducer.this.getEndpoint(), this.exchange, responseStatus);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            return AsyncHandler.State.CONTINUE;
        }

        public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} onHeadersReceived {}", (Object)this.exchange.getExchangeId(), (Object)headers);
            }
            try {
                AhcProducer.this.getEndpoint().getBinding().onHeadersReceived(AhcProducer.this.getEndpoint(), this.exchange, headers);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            return AsyncHandler.State.CONTINUE;
        }
    }
}

