/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc.helper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class AhcHelper {
    private AhcHelper() {
    }

    public static void writeObjectToStream(OutputStream stream, Object target) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(target);
        oos.flush();
        IOHelper.close((Closeable)oos);
    }

    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        if (is == null) {
            return null;
        }
        Object answer = null;
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        if (contentType != null) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.getCharsetNameFromContentType((String)contentType));
        }
    }

    public static String createURL(Exchange exchange, AhcEndpoint endpoint) throws URISyntaxException, UnsupportedEncodingException {
        String url = AhcHelper.doCreateURL(exchange, endpoint);
        return URISupport.normalizeUri((String)url);
    }

    private static String doCreateURL(Exchange exchange, AhcEndpoint endpoint) {
        Object uri = null;
        if (!endpoint.isBridgeEndpoint()) {
            uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getHttpUri().toASCIIString();
        }
        uri = AhcHelper.resolvePlaceholdersInURI(exchange, uri);
        String path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        if (path != null) {
            block10: {
                if (path.startsWith("/")) {
                    try {
                        URI baseURI = AhcHelper.getBaseURI(exchange);
                        String basePath = baseURI.getPath();
                        if (path.startsWith(basePath)) {
                            if ((path = path.substring(basePath.length())).startsWith("/")) {
                                path = path.substring(1);
                            }
                            break block10;
                        }
                        throw new RuntimeExchangeException("Cannot analyze the Exchange.HTTP_PATH header, due to: cannot find the right HTTP_BASE_URI", exchange);
                    }
                    catch (Exception t) {
                        throw new RuntimeExchangeException("Cannot analyze the Exchange.HTTP_PATH header, due to: " + t.getMessage(), exchange, (Throwable)t);
                    }
                }
            }
            if (path.length() > 0) {
                if (!((String)uri).endsWith("/")) {
                    uri = (String)uri + "/";
                }
                uri = ((String)uri).concat(path);
            }
        }
        uri = UnsafeUriCharactersEncoder.encodeHttpURI((String)uri);
        return uri;
    }

    private static URI getBaseURI(Exchange exchange) throws URISyntaxException {
        String baseURIString = (String)exchange.getIn().getHeader("CamelHttpBaseUri", String.class);
        if (baseURIString == null) {
            baseURIString = exchange.getFromEndpoint() != null ? exchange.getFromEndpoint().getEndpointUri() : "/";
        }
        URI baseURI = new URI(baseURIString);
        return baseURI;
    }

    private static String resolvePlaceholdersInURI(Exchange exchange, String uri) {
        try {
            uri = exchange.getContext().resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uri, exchange, (Throwable)e);
        }
        return uri;
    }

    public static URI createURI(Exchange exchange, String url, AhcEndpoint endpoint) throws URISyntaxException {
        URI uri = new URI(url);
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        if (queryString == null) {
            queryString = uri.getQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encodeHttpURI((String)queryString);
            uri = URISupport.createURIWithQuery((URI)uri, (String)queryString);
        }
        return uri;
    }
}

