/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType
@XmlEnum
public enum ExchangePattern {
    InOnly,
    InOut,
    InOptionalOut;

    protected static final Map<String, ExchangePattern> MAP;

    public String getWsdlUri() {
        switch (this) {
            case InOnly: {
                return "http://www.w3.org/ns/wsdl/in-only";
            }
            case InOptionalOut: {
                return "http://www.w3.org/ns/wsdl/in-opt-out";
            }
            case InOut: {
                return "http://www.w3.org/ns/wsdl/in-out";
            }
        }
        throw new IllegalArgumentException("Unknown message exchange pattern: " + (Object)((Object)this));
    }

    public boolean isInCapable() {
        return true;
    }

    public boolean isOutCapable() {
        switch (this) {
            case InOnly: {
                return false;
            }
        }
        return true;
    }

    public boolean isFaultCapable() {
        switch (this) {
            case InOnly: {
                return false;
            }
        }
        return true;
    }

    public static ExchangePattern fromWsdlUri(String wsdlUri) {
        return MAP.get(wsdlUri);
    }

    public static ExchangePattern asEnum(String value) {
        try {
            return ExchangePattern.valueOf(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown message exchange pattern: " + value, e);
        }
    }

    static {
        MAP = new HashMap<String, ExchangePattern>();
        for (ExchangePattern mep : ExchangePattern.values()) {
            String uri = mep.getWsdlUri();
            MAP.put(uri, mep);
            String name = uri.substring(uri.lastIndexOf(47) + 1);
            MAP.put("http://www.w3.org/2004/08/wsdl/" + name, mep);
            MAP.put("http://www.w3.org/2006/01/wsdl/" + name, mep);
        }
    }
}

