/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.mq;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.MQ2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-mq")
public class MQ2Component
extends DefaultComponent {
    @Metadata
    private MQ2Configuration configuration = new MQ2Configuration();

    public MQ2Component() {
        this(null);
    }

    public MQ2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MQ2Configuration configuration = this.configuration != null ? this.configuration.copy() : new MQ2Configuration();
        MQ2Endpoint endpoint = new MQ2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && configuration.getAmazonMqClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, amazonMQClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MQ2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MQ2Configuration configuration) {
        this.configuration = configuration;
    }
}

