/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import java.net.URI;
import org.apache.camel.component.file.azure.FilesPath;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class FilesConfiguration
extends RemoteFileConfiguration {
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final String DEFAULT_INTERNET_DOMAIN = "file.core.windows.net";
    @UriParam(label="both", description="Shared key (storage account key)", secret=true)
    private String sharedKey;
    @UriPath(name="account", description="The account to use")
    @Metadata(required=true)
    private String account;
    @UriPath(name="share", description="The share to use")
    @Metadata(required=true)
    private String share;

    public FilesConfiguration() {
        this.setProtocol("azure-files");
    }

    public FilesConfiguration(URI uri) {
        super(uri);
        this.setSendNoop(false);
        this.setBinary(true);
        this.setPassiveMode(true);
    }

    protected void setDefaultPort() {
        this.setPort(443);
    }

    public void setDirectory(String path) {
        if (path == null || path.isBlank() || path.contains("//") || path.equals("/")) {
            throw new IllegalArgumentException("Illegal endpoint URI path (expected share[/dir]): " + path);
        }
        String dir = FilesPath.trimTrailingSeparator(path);
        int separator = (dir = FilesPath.trimLeadingSeparator(dir)).indexOf(47);
        if (separator == -1) {
            this.share = dir;
            dir = "/";
        } else {
            this.share = dir.substring(0, separator);
            dir = dir.substring(separator);
        }
        super.setDirectory(dir);
    }

    public String getShare() {
        return this.share;
    }

    public String remoteServerInformation() {
        return this.getProtocol() + "://" + this.getAccount();
    }

    public void setHost(String accountOrHostname) {
        int dot = accountOrHostname.indexOf(46);
        boolean hasDot = dot >= 0;
        this.account = hasDot ? accountOrHostname.substring(0, dot) : accountOrHostname;
        super.setHost((String)(hasDot ? accountOrHostname : this.account + ".file.core.windows.net"));
    }

    public String getAccount() {
        return this.account;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }
}

