/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import com.azure.storage.file.share.models.ShareFileItem;
import java.time.Duration;
import org.apache.camel.Category;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.azure.FilesComponent;
import org.apache.camel.component.file.azure.FilesConfiguration;
import org.apache.camel.component.file.azure.FilesConsumer;
import org.apache.camel.component.file.azure.FilesHeaders;
import org.apache.camel.component.file.azure.FilesOperations;
import org.apache.camel.component.file.azure.FilesProducer;
import org.apache.camel.component.file.azure.FilesToken;
import org.apache.camel.component.file.azure.strategy.FilesProcessStrategyFactory;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.22.0", scheme="azure-files", extendsScheme="file", title="Azure Files", syntax="azure-files:account/share", category={Category.CLOUD, Category.FILE}, headersClass=FilesHeaders.class)
@Metadata(excludeProperties="appendChars,readLockIdempotentReleaseAsync,readLockIdempotentReleaseAsyncPoolSize,readLockIdempotentReleaseDelay,readLockIdempotentReleaseExecutorService,directoryMustExist,extendedAttributes,probeContentType,startingDirectoryMustExist,startingDirectoryMustHaveAccess,chmodDirectory,forceWrites,copyAndDeleteOnRenameFail,renameUsingCopy,synchronous,passive,passiveMode,stepwise,useList,binary,charset,password,siteCommand,fastExistsCheck,soTimeout,separator,sendNoop,ignoreFileNotFoundOrPermissionError,bufferSize,moveExisting,username,host")
@ManagedResource(description="Camel Azure Files endpoint")
public class FilesEndpoint
extends RemoteFileEndpoint<ShareFileItem> {
    @UriParam
    protected FilesConfiguration configuration;
    @UriParam
    protected FilesToken token = new FilesToken();
    @UriParam(label="consumer")
    protected boolean resumeDownload;

    public FilesEndpoint() {
    }

    public FilesEndpoint(String uri, FilesComponent component, FilesConfiguration configuration) {
        super(uri, (RemoteFileComponent)component, (RemoteFileConfiguration)configuration);
        this.setConfiguration((GenericFileConfiguration)configuration);
    }

    public String getScheme() {
        return "azure-files";
    }

    public RemoteFileConsumer<ShareFileItem> createConsumer(Processor processor) throws Exception {
        if (this.isResumeDownload() && ObjectHelper.isEmpty((String)this.getLocalWorkDirectory())) {
            throw new IllegalArgumentException("The option localWorkDirectory must be configured when resumeDownload=true");
        }
        return super.createConsumer(processor);
    }

    protected FilesConsumer buildConsumer(Processor processor) {
        try {
            return new FilesConsumer(this, processor, this.createRemoteFileOperations(), this.processStrategy != null ? this.processStrategy : this.createGenericFileStrategy());
        }
        catch (Exception e) {
            throw new FailedToCreateConsumerException((Endpoint)this, (Throwable)e);
        }
    }

    protected FilesProducer buildProducer() {
        try {
            return new FilesProducer(this, this.createRemoteFileOperations());
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException((Endpoint)this, (Throwable)e);
        }
    }

    protected GenericFileProcessStrategy<ShareFileItem> createGenericFileStrategy() {
        return new FilesProcessStrategyFactory().createGenericFileProcessStrategy(this.getCamelContext(), this.getParamsAsMap());
    }

    public FilesOperations createRemoteFileOperations() {
        return new FilesOperations(this);
    }

    public FilesToken getToken() {
        return this.token;
    }

    public void setToken(FilesToken token) {
        this.token = token;
    }

    public FilesConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        if (!(configuration instanceof FilesConfiguration)) {
            throw new IllegalArgumentException("FilesConfiguration expected.");
        }
        super.setConfiguration(configuration);
        this.configuration = (FilesConfiguration)configuration;
    }

    public boolean isResumeDownload() {
        return this.resumeDownload;
    }

    public void setResumeDownload(boolean resumeDownload) {
        this.resumeDownload = resumeDownload;
    }

    public char getFileSeparator() {
        return '/';
    }

    public String getCharset() {
        return null;
    }

    Duration getMetadataTimeout() {
        int t1 = this.getConfiguration().getTimeout();
        long t2 = this.getReadLockCheckInterval();
        if (t2 > 0L && t2 < (long)t1) {
            return Duration.ofMillis(t2);
        }
        if (t1 > 0) {
            return Duration.ofMillis(t1);
        }
        return Duration.ofSeconds(20L);
    }

    Duration getDataTimeout() {
        int t1 = this.getConfiguration().getTimeout();
        if (t1 > 0) {
            return Duration.ofMillis(t1);
        }
        return Duration.ofDays(10L);
    }
}

