/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.component.azure.servicebus.ServiceBusConstants;
import org.apache.camel.component.azure.servicebus.ServiceBusConsumer;
import org.apache.camel.component.azure.servicebus.ServiceBusProducer;
import org.apache.camel.component.azure.servicebus.client.ServiceBusClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.12.0", scheme="azure-servicebus", title="Azure ServiceBus", syntax="azure-servicebus:topicOrQueueName", category={Category.CLOUD, Category.MESSAGING}, headersClass=ServiceBusConstants.class)
public class ServiceBusEndpoint
extends DefaultEndpoint {
    @UriParam
    private ServiceBusConfiguration configuration;
    private ServiceBusClientFactory serviceBusClientFactory = new ServiceBusClientFactory();

    public ServiceBusEndpoint(String uri, Component component, ServiceBusConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new ServiceBusProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ServiceBusConsumer eventHubConsumer = new ServiceBusConsumer(this, processor);
        this.configureConsumer((Consumer)eventHubConsumer);
        return eventHubConsumer;
    }

    public ServiceBusConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServiceBusConfiguration configuration) {
        this.configuration = configuration;
    }

    public ServiceBusClientFactory getServiceBusClientFactory() {
        return this.serviceBusClientFactory;
    }

    public void setServiceBusClientFactory(ServiceBusClientFactory serviceBusClientFactory) {
        this.serviceBusClientFactory = serviceBusClientFactory;
    }
}

