/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.debugger.BacklogDebugger;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.engine.CamelInternalProcessor;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.ErrorHandlerRedeliveryCustomizer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.WrapAwareProcessor;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannel
extends CamelInternalProcessor
implements Channel {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultChannel.class);
    private Processor errorHandler;
    private Processor nextProcessor;
    private Processor output;
    private ManagementInterceptStrategy.InstrumentationProcessor<?> instrumentationProcessor;
    private Route route;

    public DefaultChannel(CamelContext camelContext) {
        super(camelContext);
    }

    public Processor getOutput() {
        return this.errorHandler != null ? this.errorHandler : this.output;
    }

    public boolean hasNext() {
        return this.nextProcessor != null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.nextProcessor);
        return answer;
    }

    public void setOutput(Processor output) {
        this.output = output;
    }

    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public Route getRoute() {
        return this.route;
    }

    protected void doStart() throws Exception {
        this.setProcessor(this.getOutput());
        ServiceHelper.startService((Object[])new Object[]{this.errorHandler, this.output});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.output, this.errorHandler});
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.output, this.errorHandler});
    }

    public void initChannel(Route route, NamedNode definition, NamedNode childDefinition, List<InterceptStrategy> interceptors, Processor nextProcessor, NamedRoute routeDefinition, boolean first) throws Exception {
        this.route = route;
        this.nextProcessor = nextProcessor;
        CamelContextAware.trySetCamelContext((Object)nextProcessor, (CamelContext)this.camelContext);
        NamedNode targetOutputDef = childDefinition != null ? childDefinition : definition;
        LOG.trace("Initialize channel for target: {}", (Object)targetOutputDef);
        ManagementInterceptStrategy managed = route.getManagementInterceptStrategy();
        if (managed != null) {
            this.instrumentationProcessor = managed.createProcessor(targetOutputDef, nextProcessor);
        }
        if (route.isMessageHistory().booleanValue()) {
            MessageHistoryFactory factory = this.camelContext.getMessageHistoryFactory();
            this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(factory, targetOutputDef));
        }
        this.addAdvice(new CamelInternalProcessor.NodeHistoryAdvice(targetOutputDef));
        if (route.isDebugging().booleanValue()) {
            Object debugger;
            if (this.camelContext.getDebugger() != null) {
                debugger = this.camelContext.getDebugger();
                this.addAdvice(new CamelInternalProcessor.DebuggerAdvice((Debugger)debugger, nextProcessor, targetOutputDef));
            } else {
                debugger = DefaultChannel.getOrCreateBacklogDebugger(this.camelContext);
                this.camelContext.addService(debugger);
                this.addAdvice(new CamelInternalProcessor.BacklogDebuggerAdvice((BacklogDebugger)((Object)debugger), nextProcessor, targetOutputDef));
            }
        }
        if (route.isBacklogTracing().booleanValue()) {
            BacklogTracer backlogTracer = DefaultChannel.getOrCreateBacklogTracer(this.camelContext);
            this.addAdvice(new CamelInternalProcessor.BacklogTracerAdvice(backlogTracer, targetOutputDef, routeDefinition, first));
        }
        if (route.isTracing().booleanValue()) {
            Tracer tracer = this.camelContext.getTracer();
            this.addAdvice(new CamelInternalProcessor.TracingAdvice(tracer, targetOutputDef, routeDefinition, first));
        }
        interceptors.sort((Comparator<InterceptStrategy>)OrderedComparator.get());
        Collections.reverse(interceptors);
        Processor target = nextProcessor;
        for (InterceptStrategy strategy : interceptors) {
            Processor next = target == nextProcessor ? null : nextProcessor;
            Processor wrapped = strategy.wrapProcessorInInterceptors(route.getCamelContext(), targetOutputDef, target, next);
            if (!(wrapped instanceof AsyncProcessor)) {
                LOG.warn("Interceptor: {} at: {} does not return an AsyncProcessor instance. This causes the asynchronous routing engine to not work as optimal as possible. See more details at the InterceptStrategy javadoc. Camel will use a bridge to adapt the interceptor to the asynchronous routing engine, but its not the most optimal solution. Please consider changing your interceptor to comply.", (Object)strategy, (Object)definition);
            }
            if (!(wrapped instanceof WrapAwareProcessor)) {
                wrapped = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getInternalProcessorFactory().createWrapProcessor(wrapped, target);
            }
            target = wrapped;
        }
        if (route.isStreamCaching().booleanValue()) {
            this.addAdvice(new CamelInternalProcessor.StreamCachingAdvice(this.camelContext.getStreamCachingStrategy()));
        }
        if (route.getDelayer() != null && route.getDelayer() > 0L) {
            this.addAdvice(new CamelInternalProcessor.DelayerAdvice(route.getDelayer()));
        }
        this.output = target;
    }

    public void postInitChannel() throws Exception {
        if (this.instrumentationProcessor != null) {
            ErrorHandlerRedeliveryCustomizer erh;
            boolean redeliveryPossible = false;
            if (this.errorHandler instanceof ErrorHandlerRedeliveryCustomizer && (redeliveryPossible = (erh = (ErrorHandlerRedeliveryCustomizer)this.errorHandler).determineIfRedeliveryIsEnabled())) {
                Processor currentOutput = erh.getOutput();
                this.instrumentationProcessor.setProcessor(currentOutput);
                erh.changeOutput(this.instrumentationProcessor);
            }
            if (!redeliveryPossible) {
                this.addAdvice(CamelInternalProcessor.wrap(this.instrumentationProcessor));
            }
        }
    }

    private static BacklogTracer getOrCreateBacklogTracer(CamelContext camelContext) {
        Map map;
        BacklogTracer tracer = null;
        if (camelContext.getRegistry() != null && (map = camelContext.getRegistry().findByTypeWithName(BacklogTracer.class)).size() == 1) {
            tracer = (BacklogTracer)((Object)map.values().iterator().next());
        }
        if (tracer == null) {
            tracer = (BacklogTracer)((Object)camelContext.getExtension(BacklogTracer.class));
        }
        if (tracer == null) {
            tracer = BacklogTracer.createTracer(camelContext);
            camelContext.setExtension(BacklogTracer.class, (Object)tracer);
        }
        return tracer;
    }

    private static BacklogDebugger getOrCreateBacklogDebugger(CamelContext camelContext) {
        Map map;
        BacklogDebugger debugger = null;
        if (camelContext.getRegistry() != null && (map = camelContext.getRegistry().findByTypeWithName(BacklogDebugger.class)).size() == 1) {
            debugger = (BacklogDebugger)((Object)map.values().iterator().next());
        }
        if (debugger == null) {
            debugger = (BacklogDebugger)((Object)camelContext.hasService(BacklogDebugger.class));
        }
        if (debugger == null) {
            debugger = BacklogDebugger.createDebugger(camelContext);
        }
        return debugger;
    }

    @Override
    public String toString() {
        return "Channel[" + this.nextProcessor + "]";
    }
}

