/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsonable;
import org.apache.camel.util.json.Jsoner;

public final class DefaultBacklogTracerEventMessage
implements BacklogTracerEventMessage {
    private final StopWatch watch = new StopWatch();
    private final boolean first;
    private final boolean last;
    private final long uid;
    private final long timestamp;
    private final String location;
    private final String routeId;
    private final String toNode;
    private final String exchangeId;
    private final String threadName;
    private final boolean rest;
    private final boolean template;
    private final String messageAsXml;
    private final String messageAsJSon;
    private String exceptionAsXml;
    private String exceptionAsJSon;
    private long duration;
    private boolean done;

    public DefaultBacklogTracerEventMessage(boolean first, boolean last, long uid, long timestamp, String location, String routeId, String toNode, String exchangeId, boolean rest, boolean template, String messageAsXml, String messageAsJSon) {
        this.first = first;
        this.last = last;
        this.uid = uid;
        this.timestamp = timestamp;
        this.location = location;
        this.routeId = routeId;
        this.toNode = toNode;
        this.exchangeId = exchangeId;
        this.rest = rest;
        this.template = template;
        this.messageAsXml = messageAsXml;
        this.messageAsJSon = messageAsJSon;
        this.threadName = Thread.currentThread().getName();
    }

    public void doneProcessing() {
        this.done = true;
        this.duration = this.watch.taken();
    }

    public long getUid() {
        return this.uid;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public boolean isRest() {
        return this.rest;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public String getToNode() {
        return this.toNode;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public String getProcessingThreadName() {
        return this.threadName;
    }

    public String getMessageAsXml() {
        return this.messageAsXml;
    }

    public String getMessageAsJSon() {
        return this.messageAsJSon;
    }

    public long getElapsed() {
        return this.done ? this.duration : this.watch.taken();
    }

    public void setElapsed(long elapsed) {
        this.duration = elapsed;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isFailed() {
        return this.hasException();
    }

    public boolean hasException() {
        return this.exceptionAsXml != null || this.exceptionAsJSon != null;
    }

    public String getExceptionAsXml() {
        return this.exceptionAsXml;
    }

    public void setExceptionAsXml(String exceptionAsXml) {
        this.exceptionAsXml = exceptionAsXml;
    }

    public String getExceptionAsJSon() {
        return this.exceptionAsJSon;
    }

    public void setExceptionAsJSon(String exceptionAsJSon) {
        this.exceptionAsJSon = exceptionAsJSon;
    }

    public String toString() {
        return "DefaultBacklogTracerEventMessage[" + this.exchangeId + " at " + this.toNode + "]";
    }

    public String toXml(int indent) {
        StringBuilder prefix = new StringBuilder();
        prefix.append(" ".repeat(indent));
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)prefix).append("<").append("backlogTracerEventMessage").append(">\n");
        sb.append((CharSequence)prefix).append("  <uid>").append(this.uid).append("</uid>\n");
        sb.append((CharSequence)prefix).append("  <first>").append(this.first).append("</first>\n");
        sb.append((CharSequence)prefix).append("  <last>").append(this.last).append("</last>\n");
        sb.append((CharSequence)prefix).append("  <rest>").append(this.rest).append("</rest>\n");
        sb.append((CharSequence)prefix).append("  <template>").append(this.template).append("</template>\n");
        String ts = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(this.timestamp);
        sb.append((CharSequence)prefix).append("  <timestamp>").append(ts).append("</timestamp>\n");
        sb.append((CharSequence)prefix).append("  <elapsed>").append(this.getElapsed()).append("</elapsed>\n");
        sb.append((CharSequence)prefix).append("  <threadName>").append(this.getProcessingThreadName()).append("</threadName>\n");
        sb.append((CharSequence)prefix).append("  <done>").append(this.isDone()).append("</done>\n");
        sb.append((CharSequence)prefix).append("  <failed>").append(this.isFailed()).append("</failed>\n");
        if (this.getLocation() != null) {
            sb.append((CharSequence)prefix).append("  <location>").append(this.getLocation()).append("</location>\n");
        }
        sb.append((CharSequence)prefix).append("  <routeId>").append(this.routeId != null ? this.routeId : "").append("</routeId>\n");
        if (this.toNode != null) {
            sb.append((CharSequence)prefix).append("  <toNode>").append(this.toNode).append("</toNode>\n");
        } else {
            sb.append((CharSequence)prefix).append("  <toNode>").append(this.routeId).append("</toNode>\n");
        }
        sb.append((CharSequence)prefix).append("  <exchangeId>").append(this.exchangeId).append("</exchangeId>\n");
        sb.append((CharSequence)prefix).append(this.messageAsXml).append("\n");
        if (this.exceptionAsXml != null) {
            sb.append((CharSequence)prefix).append(this.exceptionAsXml).append("\n");
        }
        sb.append((CharSequence)prefix).append("</").append("backlogTracerEventMessage").append(">");
        return sb.toString();
    }

    public String toJSon(int indent) {
        Jsonable jo = (Jsonable)this.asJSon();
        if (indent > 0) {
            return Jsoner.prettyPrint((String)jo.toJson(), (int)indent);
        }
        return Jsoner.prettyPrint((String)jo.toJson());
    }

    public Map<String, Object> asJSon() {
        JsonObject msg2;
        JsonObject jo = new JsonObject();
        jo.put((Object)"uid", (Object)this.uid);
        jo.put((Object)"first", (Object)this.first);
        jo.put((Object)"last", (Object)this.last);
        jo.put((Object)"rest", (Object)this.rest);
        jo.put((Object)"template", (Object)this.template);
        if (this.location != null) {
            jo.put((Object)"location", (Object)this.location);
        }
        if (this.routeId != null) {
            jo.put((Object)"routeId", (Object)this.routeId);
        }
        if (this.toNode != null) {
            jo.put((Object)"nodeId", (Object)this.toNode);
        }
        if (this.timestamp > 0L) {
            jo.put((Object)"timestamp", (Object)this.timestamp);
        }
        jo.put((Object)"elapsed", (Object)this.getElapsed());
        jo.put((Object)"threadName", (Object)this.getProcessingThreadName());
        jo.put((Object)"done", (Object)this.isDone());
        jo.put((Object)"failed", (Object)this.isFailed());
        try {
            msg2 = (JsonObject)Jsoner.deserialize((String)this.messageAsJSon);
            msg2 = (JsonObject)msg2.getMap("message");
            jo.put((Object)"message", (Object)msg2);
            msg2 = (JsonObject)msg2.getMap("body");
            Object body = msg2.get((Object)"value");
            if ("[Body is null]".equals(body)) {
                msg2.replace((Object)"value", null);
            }
        }
        catch (Exception msg2) {
            // empty catch block
        }
        if (this.exceptionAsJSon != null) {
            try {
                msg2 = (JsonObject)Jsoner.deserialize((String)this.exceptionAsJSon);
                jo.put((Object)"exception", msg2.get((Object)"exception"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jo;
    }
}

