/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.concurrent.NamedThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ReactiveExecutor")
public class DefaultReactiveExecutor
extends ServiceSupport
implements ReactiveExecutor,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReactiveExecutor.class);
    private boolean statisticsEnabled;
    private final AtomicInteger createdWorkers = new AtomicInteger();
    private final LongAdder runningWorkers = new LongAdder();
    private final LongAdder pendingTasks = new LongAdder();
    private final NamedThreadLocal<Worker> workers = new NamedThreadLocal("CamelReactiveWorker", () -> {
        int number = this.createdWorkers.incrementAndGet();
        return new Worker(number, this);
    });

    public void schedule(Runnable runnable) {
        ((Worker)this.workers.get()).schedule(runnable, false, false, false);
    }

    public void scheduleMain(Runnable runnable) {
        ((Worker)this.workers.get()).schedule(runnable, true, true, false);
    }

    public void scheduleSync(Runnable runnable) {
        ((Worker)this.workers.get()).schedule(runnable, false, true, true);
    }

    public void scheduleQueue(Runnable runnable) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("ScheduleQueue: {}", (Object)runnable);
        }
        ((Worker)this.workers.get()).queue.add(runnable);
    }

    public boolean executeFromQueue() {
        return ((Worker)this.workers.get()).executeFromQueue();
    }

    @ManagedAttribute(description="Whether statistics is enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="Number of created workers")
    public int getCreatedWorkers() {
        return this.createdWorkers.get();
    }

    @ManagedAttribute(description="Number of running workers")
    public int getRunningWorkers() {
        return this.runningWorkers.intValue();
    }

    @ManagedAttribute(description="Number of pending tasks")
    public int getPendingTasks() {
        return this.pendingTasks.intValue();
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled() && this.statisticsEnabled) {
            LOG.debug("Stopping DefaultReactiveExecutor [createdWorkers: {}, runningWorkers: {}, pendingTasks: {}]", new Object[]{this.getCreatedWorkers(), this.getRunningWorkers(), this.getPendingTasks()});
        }
    }

    protected void doShutdown() throws Exception {
        this.workers.remove();
    }

    private static class Worker {
        private final int number;
        private final DefaultReactiveExecutor executor;
        private final boolean stats;
        private volatile Deque<Runnable> queue = new ArrayDeque<Runnable>();
        private volatile Deque<Deque<Runnable>> back;
        private volatile boolean running;

        public Worker(int number, DefaultReactiveExecutor executor) {
            this.number = number;
            this.executor = executor;
            this.stats = executor != null && executor.isStatisticsEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(Runnable runnable, boolean first, boolean main, boolean sync) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Schedule [first={}, main={}, sync={}]: {}", new Object[]{first, main, sync, runnable});
            }
            if (main && !this.queue.isEmpty()) {
                if (this.back == null) {
                    this.back = new ArrayDeque<Deque<Runnable>>();
                }
                this.back.push(this.queue);
                this.queue = new ArrayDeque<Runnable>();
            }
            if (first) {
                this.queue.addFirst(runnable);
                if (this.stats) {
                    this.executor.pendingTasks.increment();
                }
            } else {
                this.queue.addLast(runnable);
                if (this.stats) {
                    this.executor.pendingTasks.increment();
                }
            }
            if (!this.running || sync) {
                this.running = true;
                if (this.stats) {
                    this.executor.runningWorkers.increment();
                }
                try {
                    this.executeReactiveWork();
                }
                finally {
                    this.running = false;
                    if (this.stats) {
                        this.executor.runningWorkers.decrement();
                    }
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Queuing reactive work: {}", (Object)runnable);
            }
        }

        private void executeReactiveWork() {
            while (true) {
                Runnable polled;
                if ((polled = this.queue.pollFirst()) == null) {
                    if (this.back == null || this.back.isEmpty()) break;
                    this.queue = this.back.pollFirst();
                    continue;
                }
                try {
                    if (this.stats) {
                        this.executor.pendingTasks.decrement();
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Worker #{} running: {}", (Object)this.number, (Object)polled);
                    }
                    polled.run();
                }
                catch (Exception t) {
                    LOG.warn("Error executing reactive work due to {}. This exception is ignored.", (Object)t.getMessage(), (Object)t);
                }
            }
        }

        boolean executeFromQueue() {
            Runnable polled;
            Runnable runnable = polled = this.queue != null ? this.queue.pollFirst() : null;
            if (polled == null) {
                return false;
            }
            try {
                if (this.stats) {
                    this.executor.pendingTasks.decrement();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running: {}", (Object)polled);
                }
                polled.run();
            }
            catch (Exception t) {
                LOG.warn("Error executing reactive work due to {}. This exception is ignored.", (Object)t.getMessage(), (Object)t);
            }
            return true;
        }
    }
}

