/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangeConstantProvider;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.impl.engine.DefaultContextPluginManager;
import org.apache.camel.impl.engine.DefaultManagementStrategyFactory;
import org.apache.camel.impl.engine.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.engine.HashMapHeadersMapFactory;
import org.apache.camel.impl.engine.InternalRouteController;
import org.apache.camel.impl.engine.TransformerKey;
import org.apache.camel.impl.engine.ValidatorKey;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ManagementStrategyFactory;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.PluginManager;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RestRegistryFactory;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.NormalizedUri;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.startup.DefaultStartupStepRecorder;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCamelContextExtension
implements ExtendedCamelContext {
    private final AbstractCamelContext camelContext;
    private final ThreadLocal<Boolean> isSetupRoutes = new ThreadLocal();
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private final Map<String, FactoryFinder> factories = new ConcurrentHashMap<String, FactoryFinder>();
    private final Map<String, FactoryFinder> bootstrapFactories = new ConcurrentHashMap<String, FactoryFinder>();
    private final Set<LogListener> logListeners = new LinkedHashSet<LogListener>();
    private final PluginManager pluginManager = new DefaultContextPluginManager();
    private final RouteController internalRouteController;
    private final List<BootstrapCloseable> bootstraps = new CopyOnWriteArrayList<BootstrapCloseable>();
    private volatile String description;
    private volatile ExchangeFactory exchangeFactory;
    private volatile ExchangeFactoryManager exchangeFactoryManager;
    private volatile ProcessorExchangeFactory processorExchangeFactory;
    private volatile ReactiveExecutor reactiveExecutor;
    private volatile Registry registry;
    private volatile ManagementStrategy managementStrategy;
    private volatile ManagementMBeanAssembler managementMBeanAssembler;
    private volatile HeadersMapFactory headersMapFactory;
    private volatile boolean eventNotificationApplicable;
    private volatile CamelContextNameStrategy nameStrategy;
    private volatile ManagementNameStrategy managementNameStrategy;
    private volatile PropertiesComponent propertiesComponent;
    private volatile RestRegistryFactory restRegistryFactory;
    private volatile RestConfiguration restConfiguration;
    private volatile RestRegistry restRegistry;
    private volatile ClassResolver classResolver;
    private volatile MessageHistoryFactory messageHistoryFactory;
    private volatile StreamCachingStrategy streamCachingStrategy;
    private volatile InflightRepository inflightRepository;
    private volatile UuidGenerator uuidGenerator;
    private volatile Tracer tracer;
    private volatile TransformerRegistry<TransformerKey> transformerRegistry;
    private volatile ValidatorRegistry<ValidatorKey> validatorRegistry;
    private volatile TypeConverterRegistry typeConverterRegistry;
    private volatile TypeConverter typeConverter;
    private volatile RouteController routeController;
    private volatile ShutdownStrategy shutdownStrategy;
    private volatile ExecutorServiceManager executorServiceManager;
    private volatile Injector injector;
    private volatile StartupStepRecorder startupStepRecorder = new DefaultStartupStepRecorder();
    @Deprecated
    private ErrorHandlerFactory errorHandlerFactory;
    private String basePackageScan;
    private final Object lock = new Object();
    private volatile FactoryFinder bootstrapFactoryFinder;

    public DefaultCamelContextExtension(AbstractCamelContext camelContext) {
        this.camelContext = camelContext;
        this.internalRouteController = new InternalRouteController(camelContext);
    }

    public byte getStatusPhase() {
        return this.camelContext.getStatusPhase();
    }

    public String getName() {
        return this.camelContext.getNameStrategy().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CamelContextNameStrategy getNameStrategy() {
        if (this.nameStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.nameStrategy == null) {
                    this.setNameStrategy(this.camelContext.createCamelContextNameStrategy());
                }
            }
        }
        return this.nameStrategy;
    }

    void setNameStrategy(CamelContextNameStrategy nameStrategy) {
        this.nameStrategy = this.camelContext.getInternalServiceManager().addService(this.camelContext, nameStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagementNameStrategy getManagementNameStrategy() {
        if (this.managementNameStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.managementNameStrategy == null) {
                    this.setManagementNameStrategy(this.camelContext.createManagementNameStrategy());
                }
            }
        }
        return this.managementNameStrategy;
    }

    void setManagementNameStrategy(ManagementNameStrategy managementNameStrategy) {
        this.managementNameStrategy = this.camelContext.getInternalServiceManager().addService(this.camelContext, managementNameStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertiesComponent getPropertiesComponent() {
        if (this.propertiesComponent == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.propertiesComponent == null) {
                    this.setPropertiesComponent(this.camelContext.createPropertiesComponent());
                }
            }
        }
        return this.propertiesComponent;
    }

    void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = this.camelContext.getInternalServiceManager().addService(this.camelContext, propertiesComponent);
    }

    public void setName(String name) {
        this.camelContext.setNameStrategy(new ExplicitCamelContextNameStrategy(name));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Endpoint hasEndpoint(NormalizedEndpointUri uri) {
        if (this.camelContext.getEndpointRegistry().isEmpty()) {
            return null;
        }
        return (Endpoint)this.camelContext.getEndpointRegistry().get((Object)uri);
    }

    public NormalizedEndpointUri normalizeUri(String uri) {
        try {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.camelContext, (String)uri);
            return NormalizedUri.newNormalizedUri((String)uri, (boolean)false);
        }
        catch (ResolveEndpointFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
    }

    public Endpoint getEndpoint(NormalizedEndpointUri uri) {
        return this.camelContext.doGetEndpoint(uri.getUri(), null, true, false);
    }

    public Endpoint getPrototypeEndpoint(String uri) {
        return this.camelContext.doGetEndpoint(uri, null, false, true);
    }

    public Endpoint getPrototypeEndpoint(NormalizedEndpointUri uri) {
        return this.camelContext.doGetEndpoint(uri.getUri(), null, true, true);
    }

    public Endpoint getEndpoint(NormalizedEndpointUri uri, Map<String, Object> parameters) {
        return this.camelContext.doGetEndpoint(uri.getUri(), parameters, true, false);
    }

    public void registerEndpointCallback(EndpointStrategy strategy) {
        if (!this.camelContext.getEndpointStrategies().contains(strategy)) {
            this.camelContext.getEndpointStrategies().add(strategy);
            for (Endpoint endpoint : this.camelContext.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == null) continue;
                this.camelContext.getEndpointRegistry().put((Object)this.camelContext.getEndpointKey(endpoint.getEndpointUri()), (Object)newEndpoint);
            }
        }
    }

    public List<RouteStartupOrder> getRouteStartupOrder() {
        return this.camelContext.getRouteStartupOrder();
    }

    public boolean isSetupRoutes() {
        Boolean answer = this.isSetupRoutes.get();
        return answer != null && answer != false;
    }

    public void addBootstrap(BootstrapCloseable bootstrap) {
        this.bootstraps.add(bootstrap);
    }

    void closeBootstraps() {
        for (BootstrapCloseable bootstrap : this.bootstraps) {
            try {
                bootstrap.close();
            }
            catch (Exception e) {
                DefaultCamelContextExtension.logger().warn("Error during closing bootstrap. This exception is ignored.", (Throwable)e);
            }
        }
        this.bootstraps.clear();
    }

    List<BootstrapCloseable> getBootstraps() {
        return this.bootstraps;
    }

    public List<Service> getServices() {
        return this.camelContext.getInternalServiceManager().getServices();
    }

    public String resolvePropertyPlaceholders(String text, boolean keepUnresolvedOptional) {
        if (text != null && text.contains("{{")) {
            String answer = this.camelContext.getPropertiesComponent().parseUri(text, keepUnresolvedOptional);
            DefaultCamelContextExtension.logger().debug("Resolved text: {} -> {}", (Object)text, (Object)answer);
            return answer;
        }
        if (text != null && text.startsWith("Exchange.")) {
            String field = StringHelper.after((String)text, (String)"Exchange.");
            String constant = ExchangeConstantProvider.lookup((String)field);
            if (constant != null) {
                DefaultCamelContextExtension.logger().debug("Resolved constant: {} -> {}", (Object)text, (Object)constant);
                return constant;
            }
            throw new IllegalArgumentException("Constant field with name: " + field + " not found on Exchange.class");
        }
        return text;
    }

    public ManagementMBeanAssembler getManagementMBeanAssembler() {
        return this.managementMBeanAssembler;
    }

    void setManagementMBeanAssembler(ManagementMBeanAssembler managementMBeanAssembler) {
        this.managementMBeanAssembler = this.camelContext.getInternalServiceManager().addService(this.camelContext, managementMBeanAssembler, false);
    }

    void stopRegistry() {
        ServiceHelper.stopService((Object)this.registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registry getRegistry() {
        if (this.registry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.registry == null) {
                    this.setRegistry(this.camelContext.createRegistry());
                }
            }
        }
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        CamelContextAware.trySetCamelContext((Object)registry, (CamelContext)this.camelContext);
        this.registry = registry;
    }

    public void setupRoutes(boolean done) {
        if (done) {
            this.isSetupRoutes.remove();
        } else {
            this.isSetupRoutes.set(true);
        }
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        if (!this.interceptStrategies.contains(interceptStrategy)) {
            this.interceptStrategies.add(interceptStrategy);
        }
    }

    public Set<LogListener> getLogListeners() {
        return this.logListeners;
    }

    public void addLogListener(LogListener listener) {
        this.logListeners.add(listener);
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    public boolean isEventNotificationApplicable() {
        return this.eventNotificationApplicable;
    }

    public void setEventNotificationApplicable(boolean eventNotificationApplicable) {
        this.eventNotificationApplicable = eventNotificationApplicable;
    }

    public FactoryFinder getDefaultFactoryFinder() {
        return this.getFactoryFinder("META-INF/services/org/apache/camel/");
    }

    public void setDefaultFactoryFinder(FactoryFinder factoryFinder) {
        this.factories.put("META-INF/services/org/apache/camel/", factoryFinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactoryFinder getBootstrapFactoryFinder() {
        if (this.bootstrapFactoryFinder == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.bootstrapFactoryFinder == null) {
                    this.bootstrapFactoryFinder = PluginHelper.getFactoryFinderResolver((ExtendedCamelContext)this).resolveBootstrapFactoryFinder(this.camelContext.getClassResolver());
                }
            }
        }
        return this.bootstrapFactoryFinder;
    }

    public void setBootstrapFactoryFinder(FactoryFinder factoryFinder) {
        this.bootstrapFactoryFinder = factoryFinder;
    }

    public FactoryFinder getBootstrapFactoryFinder(String path) {
        return this.bootstrapFactories.computeIfAbsent(path, this.camelContext::createBootstrapFactoryFinder);
    }

    public FactoryFinder getFactoryFinder(String path) {
        return this.factories.computeIfAbsent(path, this.camelContext::createFactoryFinder);
    }

    public void setupManagement(Map<String, Object> options) {
        DefaultCamelContextExtension.logger().trace("Setting up management");
        DefaultManagementStrategyFactory factory = null;
        if (!this.camelContext.isJMXDisabled()) {
            try {
                Object object;
                FactoryFinder finder = this.camelContext.createFactoryFinder("META-INF/services/org/apache/camel/management/");
                if (finder != null && (object = finder.newInstance("ManagementStrategyFactory").orElse(null)) instanceof ManagementStrategyFactory) {
                    factory = object;
                }
            }
            catch (Exception e) {
                DefaultCamelContextExtension.logger().warn("Cannot create JmxManagementStrategyFactory. Will fallback and disable JMX.", (Throwable)e);
            }
        }
        if (factory == null) {
            factory = new DefaultManagementStrategyFactory();
        }
        DefaultCamelContextExtension.logger().debug("Setting up management with factory: {}", (Object)factory);
        List notifiers = null;
        if (this.managementStrategy != null) {
            notifiers = this.managementStrategy.getEventNotifiers();
        }
        try {
            ManagementStrategy strategy = factory.create(this.camelContext.getCamelContextReference(), options);
            if (notifiers != null) {
                notifiers.forEach(arg_0 -> ((ManagementStrategy)strategy).addEventNotifier(arg_0));
            }
            LifecycleStrategy lifecycle = factory.createLifecycle(this.camelContext);
            factory.setupManagement(this.camelContext, strategy, lifecycle);
        }
        catch (Exception e) {
            DefaultCamelContextExtension.logger().warn("Error setting up management due {}", (Object)e.getMessage());
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String getBasePackageScan() {
        return this.basePackageScan;
    }

    public void setBasePackageScan(String basePackageScan) {
        this.basePackageScan = basePackageScan;
    }

    public HeadersMapFactory getHeadersMapFactory() {
        return this.headersMapFactory;
    }

    public void setHeadersMapFactory(HeadersMapFactory headersMapFactory) {
        this.headersMapFactory = this.camelContext.getInternalServiceManager().addService(this.camelContext, headersMapFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initEagerMandatoryServices(boolean caseInsensitive, Supplier<HeadersMapFactory> headersMapFactorySupplier) {
        if (this.headersMapFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.headersMapFactory == null) {
                    if (caseInsensitive) {
                        this.setHeadersMapFactory(headersMapFactorySupplier.get());
                    } else {
                        this.setHeadersMapFactory(new HashMapHeadersMapFactory());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeFactory getExchangeFactory() {
        if (this.exchangeFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exchangeFactory == null) {
                    this.setExchangeFactory(this.camelContext.createExchangeFactory());
                }
            }
        }
        return this.exchangeFactory;
    }

    public void setExchangeFactory(ExchangeFactory exchangeFactory) {
        exchangeFactory.setCamelContext((CamelContext)this.camelContext);
        this.exchangeFactory = exchangeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeFactoryManager getExchangeFactoryManager() {
        if (this.exchangeFactoryManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exchangeFactoryManager == null) {
                    this.setExchangeFactoryManager(this.camelContext.createExchangeFactoryManager());
                }
            }
        }
        return this.exchangeFactoryManager;
    }

    public void setExchangeFactoryManager(ExchangeFactoryManager exchangeFactoryManager) {
        this.exchangeFactoryManager = this.camelContext.getInternalServiceManager().addService(this.camelContext, exchangeFactoryManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorExchangeFactory getProcessorExchangeFactory() {
        if (this.processorExchangeFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.processorExchangeFactory == null) {
                    this.setProcessorExchangeFactory(this.camelContext.createProcessorExchangeFactory());
                }
            }
        }
        return this.processorExchangeFactory;
    }

    public void setProcessorExchangeFactory(ProcessorExchangeFactory processorExchangeFactory) {
        processorExchangeFactory.setCamelContext((CamelContext)this.camelContext);
        this.processorExchangeFactory = processorExchangeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReactiveExecutor getReactiveExecutor() {
        if (this.reactiveExecutor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.reactiveExecutor == null) {
                    this.setReactiveExecutor(this.camelContext.createReactiveExecutor());
                }
            }
        }
        return this.reactiveExecutor;
    }

    public void setReactiveExecutor(ReactiveExecutor reactiveExecutor) {
        this.reactiveExecutor = this.camelContext.getInternalServiceManager().addService(this.camelContext, reactiveExecutor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RestRegistryFactory getRestRegistryFactory() {
        if (this.restRegistryFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restRegistryFactory == null) {
                    this.setRestRegistryFactory(this.camelContext.createRestRegistryFactory());
                }
            }
        }
        return this.restRegistryFactory;
    }

    void setRestRegistryFactory(RestRegistryFactory restRegistryFactory) {
        this.restRegistryFactory = this.camelContext.getInternalServiceManager().addService(this.camelContext, restRegistryFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RestRegistry getRestRegistry() {
        if (this.restRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restRegistry == null) {
                    this.setRestRegistry(this.camelContext.createRestRegistry());
                }
            }
        }
        return this.restRegistry;
    }

    void setRestRegistry(RestRegistry restRegistry) {
        this.restRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, restRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RestConfiguration getRestConfiguration() {
        if (this.restConfiguration == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restConfiguration == null) {
                    this.setRestConfiguration(this.camelContext.createRestConfiguration());
                }
            }
        }
        return this.restConfiguration;
    }

    void setRestConfiguration(RestConfiguration restConfiguration) {
        this.restConfiguration = restConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassResolver getClassResolver() {
        if (this.classResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.classResolver == null) {
                    this.setClassResolver(this.camelContext.createClassResolver());
                }
            }
        }
        return this.classResolver;
    }

    void setClassResolver(ClassResolver classResolver) {
        this.classResolver = this.camelContext.getInternalServiceManager().addService(this.camelContext, classResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageHistoryFactory getMessageHistoryFactory() {
        if (this.messageHistoryFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.messageHistoryFactory == null) {
                    this.setMessageHistoryFactory(this.camelContext.createMessageHistoryFactory());
                }
            }
        }
        return this.messageHistoryFactory;
    }

    void setMessageHistoryFactory(MessageHistoryFactory messageHistoryFactory) {
        this.messageHistoryFactory = this.camelContext.getInternalServiceManager().addService(this.camelContext, messageHistoryFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StreamCachingStrategy getStreamCachingStrategy() {
        if (this.streamCachingStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.streamCachingStrategy == null) {
                    this.setStreamCachingStrategy(this.camelContext.createStreamCachingStrategy());
                }
            }
        }
        return this.streamCachingStrategy;
    }

    void setStreamCachingStrategy(StreamCachingStrategy streamCachingStrategy) {
        this.streamCachingStrategy = this.camelContext.getInternalServiceManager().addService(this.camelContext, streamCachingStrategy, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InflightRepository getInflightRepository() {
        if (this.inflightRepository == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.inflightRepository == null) {
                    this.setInflightRepository(this.camelContext.createInflightRepository());
                }
            }
        }
        return this.inflightRepository;
    }

    void setInflightRepository(InflightRepository repository) {
        this.inflightRepository = this.camelContext.getInternalServiceManager().addService(this.camelContext, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UuidGenerator getUuidGenerator() {
        if (this.uuidGenerator == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.uuidGenerator == null) {
                    this.setUuidGenerator(this.camelContext.createUuidGenerator());
                }
            }
        }
        return this.uuidGenerator;
    }

    void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = this.camelContext.getInternalServiceManager().addService(this.camelContext, uuidGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Tracer getTracer() {
        if (this.tracer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.tracer == null) {
                    this.setTracer(this.camelContext.createTracer());
                }
            }
        }
        return this.tracer;
    }

    void setTracer(Tracer tracer) {
        this.tracer = this.camelContext.getInternalServiceManager().addService(this.camelContext, tracer, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransformerRegistry getTransformerRegistry() {
        if (this.transformerRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.transformerRegistry == null) {
                    this.setTransformerRegistry(this.camelContext.createTransformerRegistry());
                }
            }
        }
        return this.transformerRegistry;
    }

    void setTransformerRegistry(TransformerRegistry transformerRegistry) {
        this.transformerRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, transformerRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValidatorRegistry getValidatorRegistry() {
        if (this.validatorRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.validatorRegistry == null) {
                    this.setValidatorRegistry(this.camelContext.createValidatorRegistry());
                }
            }
        }
        return this.validatorRegistry;
    }

    public void setValidatorRegistry(ValidatorRegistry validatorRegistry) {
        this.validatorRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, validatorRegistry);
    }

    void stopTypeConverterRegistry() {
        ServiceHelper.stopService((Service)this.typeConverterRegistry);
    }

    void resetTypeConverterRegistry() {
        this.typeConverterRegistry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeConverterRegistry getTypeConverterRegistry() {
        if (this.typeConverterRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.typeConverterRegistry == null) {
                    this.setTypeConverterRegistry(this.camelContext.createTypeConverterRegistry());
                    TypeConverterRegistry typeConverterRegistry = this.typeConverterRegistry;
                    if (typeConverterRegistry instanceof TypeConverter) {
                        TypeConverter newTypeConverter = (TypeConverter)typeConverterRegistry;
                        this.setTypeConverter(newTypeConverter);
                    }
                }
            }
        }
        return this.typeConverterRegistry;
    }

    void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.typeConverterRegistry = this.camelContext.getInternalServiceManager().addService(this.camelContext, typeConverterRegistry);
    }

    void stopTypeConverter() {
        ServiceHelper.stopService((Object)this.typeConverter);
    }

    void resetTypeConverter() {
        this.typeConverter = null;
    }

    TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = this.camelContext.getInternalServiceManager().addService(this.camelContext, typeConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeConverter getOrCreateTypeConverter() {
        if (this.typeConverter == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.typeConverter == null) {
                    this.setTypeConverter(this.camelContext.createTypeConverter());
                }
            }
        }
        return this.typeConverter;
    }

    void resetInjector() {
        this.injector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Injector getInjector() {
        if (this.injector == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.injector == null) {
                    this.setInjector(this.camelContext.createInjector());
                }
            }
        }
        return this.injector;
    }

    void setInjector(Injector injector) {
        this.injector = this.camelContext.getInternalServiceManager().addService(this.camelContext, injector);
    }

    void stopAndShutdownRouteController() {
        ServiceHelper.stopAndShutdownService((Object)this.routeController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RouteController getRouteController() {
        if (this.routeController == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.routeController == null) {
                    this.setRouteController(this.camelContext.createRouteController());
                }
            }
        }
        return this.routeController;
    }

    void setRouteController(RouteController routeController) {
        this.routeController = this.camelContext.getInternalServiceManager().addService(this.camelContext, routeController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShutdownStrategy getShutdownStrategy() {
        if (this.shutdownStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStrategy == null) {
                    this.setShutdownStrategy(this.camelContext.createShutdownStrategy());
                }
            }
        }
        return this.shutdownStrategy;
    }

    void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = this.camelContext.getInternalServiceManager().addService(this.camelContext, shutdownStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorServiceManager getExecutorServiceManager() {
        if (this.executorServiceManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorServiceManager == null) {
                    this.setExecutorServiceManager(this.camelContext.createExecutorServiceManager());
                }
            }
        }
        return this.executorServiceManager;
    }

    void setExecutorServiceManager(ExecutorServiceManager executorServiceManager) {
        this.executorServiceManager = this.camelContext.getInternalServiceManager().addService(this.camelContext, executorServiceManager, false);
    }

    public RouteController getInternalRouteController() {
        return this.internalRouteController;
    }

    public EndpointUriFactory getEndpointUriFactory(String scheme) {
        return PluginHelper.getUriFactoryResolver((ExtendedCamelContext)this).resolveFactory(scheme, (CamelContext)this.camelContext);
    }

    public StartupStepRecorder getStartupStepRecorder() {
        return this.startupStepRecorder;
    }

    public void setStartupStepRecorder(StartupStepRecorder startupStepRecorder) {
        this.startupStepRecorder = startupStepRecorder;
    }

    public void addRoute(Route route) {
        this.camelContext.addRoute(route);
    }

    public void removeRoute(Route route) {
        this.camelContext.removeRoute(route);
    }

    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        return this.camelContext.createErrorHandler(route, processor);
    }

    public void disposeModel() {
        this.camelContext.disposeModel();
    }

    public String getTestExcludeRoutes() {
        return this.camelContext.getTestExcludeRoutes();
    }

    ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    public <T> T getContextPlugin(Class<T> type) {
        Object ret = this.pluginManager.getContextPlugin(type);
        if (ret == null && type.isInstance((Object)this.camelContext)) {
            return type.cast((Object)this.camelContext);
        }
        return (T)ret;
    }

    public <T> void addContextPlugin(Class<T> type, T module) {
        T addedModule = this.camelContext.getInternalServiceManager().addService(this.camelContext, module);
        this.pluginManager.addContextPlugin(type, addedModule);
    }

    public <T> void lazyAddContextPlugin(Class<T> type, Supplier<T> module) {
        this.pluginManager.lazyAddContextPlugin(type, () -> this.lazyInitAndAdd(module));
    }

    private <T> T lazyInitAndAdd(Supplier<T> supplier) {
        T module = supplier.get();
        return this.camelContext.getInternalServiceManager().addService(this.camelContext, module);
    }

    private static Logger logger() {
        return Holder.LOG;
    }

    private static final class Holder {
        static final Logger LOG = LoggerFactory.getLogger(DefaultCamelContextExtension.class);

        private Holder() {
        }
    }
}

