/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.Converter;

@Converter(loader=true)
public final class CollectionConverter {
    private CollectionConverter() {
    }

    @Converter
    public static Object[] toArray(Collection<?> value) {
        return value.toArray();
    }

    @Converter
    public static List<Object> toList(Object[] array) {
        return Arrays.asList(array);
    }

    @Converter
    public static <T> List<T> toList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    @Converter
    public static <T> ArrayList<T> toArrayList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Converter
    public static Set<Object> toSet(Object[] array) {
        HashSet<Object> answer = new HashSet<Object>();
        answer.addAll(Arrays.asList(array));
        return answer;
    }

    @Converter
    public static <T> Set<T> toSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    @Converter
    public static <K, V> Set<Map.Entry<K, V>> toSet(Map<K, V> map) {
        return map.entrySet();
    }

    @Converter
    public static Properties toProperties(Map<Object, Object> map) {
        Properties answer = new Properties();
        answer.putAll(map);
        return answer;
    }

    @Converter
    public static <K, V> Hashtable<K, V> toHashtable(Map<? extends K, ? extends V> map) {
        return new Hashtable<K, V>(map);
    }

    @Converter
    public static <K, V> HashMap<K, V> toHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    @Converter
    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        LinkedList<T> result = new LinkedList<T>();
        for (T value : iterable) {
            result.add(value);
        }
        return result;
    }
}

