/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consume;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.IsSingleton;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ProxyInstantiationException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.impl.engine.DefaultConsumerTemplate;
import org.apache.camel.impl.engine.DefaultFluentProducerTemplate;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.impl.engine.SubscribeMethodProcessor;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelPostProcessorHelper
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelPostProcessorHelper.class);
    private CamelContext camelContext;

    public CamelPostProcessorHelper() {
    }

    public CamelPostProcessorHelper(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void consumerInjection(Method method, Object bean, String beanName) {
        Consume consume = method.getAnnotation(Consume.class);
        if (consume != null) {
            LOG.debug("Creating a consumer for: {}", (Object)consume);
            String uri = consume.value().isEmpty() ? consume.uri() : consume.value();
            this.subscribeMethod(method, bean, beanName, uri, consume.property(), consume.predicate());
        }
    }

    public void subscribeMethod(Method method, Object bean, String beanName, String endpointUri, String endpointProperty, String predicate) {
        String injectionPointName = method.getName();
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointProperty, injectionPointName, true);
        if (endpoint != null) {
            boolean multipleConsumer = false;
            if (endpoint instanceof MultipleConsumersSupport) {
                multipleConsumer = ((MultipleConsumersSupport)endpoint).isMultipleConsumersSupported();
            }
            try {
                SubscribeMethodProcessor processor = this.getConsumerProcessor(endpoint);
                if (multipleConsumer || processor == null) {
                    processor = new SubscribeMethodProcessor(endpoint);
                    endpoint.getCamelContext().addService((Object)processor, true);
                    processor.addMethod(bean, method, endpoint, predicate);
                    Consumer consumer = endpoint.createConsumer((Processor)processor);
                    this.startService((Service)consumer, endpoint.getCamelContext(), bean, beanName);
                } else {
                    processor.addMethod(bean, method, endpoint, predicate);
                }
                if (predicate != null) {
                    LOG.debug("Subscribed method: {} to consume from endpoint: {} with predicate: {}", new Object[]{method, endpoint, predicate});
                } else {
                    LOG.debug("Subscribed method: {} to consume from endpoint: {}", (Object)method, (Object)endpoint);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    protected void startService(Service service, CamelContext camelContext, Object bean, String beanName) throws Exception {
        if (camelContext != null) {
            camelContext.deferStartService((Object)service, true);
        } else {
            ServiceHelper.startService((Object)service);
        }
        boolean singleton = this.isSingleton(bean, beanName);
        if (!singleton) {
            LOG.debug("Service is not singleton so you must remember to stop it manually {}", (Object)service);
        }
    }

    protected SubscribeMethodProcessor getConsumerProcessor(Endpoint endpoint) {
        Set processors = endpoint.getCamelContext().hasServices(SubscribeMethodProcessor.class);
        return processors.stream().filter(s -> s.getEndpoint() == endpoint).findFirst().orElse(null);
    }

    public Endpoint getEndpointInjection(Object bean, String uri, String propertyName, String injectionPointName, boolean mandatory) {
        Endpoint answer = ObjectHelper.isEmpty((Object)uri) ? this.doGetEndpointInjection(bean, propertyName, injectionPointName) : this.doGetEndpointInjection(uri, injectionPointName, mandatory);
        if (answer instanceof DelegateEndpoint) {
            answer = ((DelegateEndpoint)answer).getEndpoint();
        }
        return answer;
    }

    private Endpoint doGetEndpointInjection(String uri, String injectionPointName, boolean mandatory) {
        return CamelContextHelper.getEndpointInjection((CamelContext)this.getCamelContext(), (String)uri, (String)injectionPointName, (boolean)mandatory);
    }

    private Endpoint doGetEndpointInjection(Object bean, String propertyName, String injectionPointName) {
        if (ObjectHelper.isEmpty((Object)propertyName)) {
            propertyName = injectionPointName;
        }
        try {
            Object value = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getBeanIntrospection().getOrElseProperty(bean, propertyName, null, false);
            if (value == null) {
                value = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getBeanIntrospection().getOrElseProperty(bean, propertyName + "Endpoint", null, false);
            }
            if (value == null && propertyName.startsWith("on")) {
                propertyName = propertyName.substring(2);
                return this.doGetEndpointInjection(bean, propertyName, injectionPointName);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof Endpoint) {
                return (Endpoint)value;
            }
            String uriOrRef = (String)this.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
            return this.getCamelContext().getEndpoint(uriOrRef);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error getting property " + propertyName + " from bean " + bean + " due " + e.getMessage(), e);
        }
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointProperty, String injectionPointName, Object bean, String beanName) {
        return this.getInjectionValue(type, endpointUri, endpointProperty, injectionPointName, bean, beanName, true);
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointProperty, String injectionPointName, Object bean, String beanName, boolean binding) {
        if (type.isAssignableFrom(ProducerTemplate.class)) {
            return this.createInjectionProducerTemplate(endpointUri, endpointProperty, injectionPointName, bean);
        }
        if (type.isAssignableFrom(FluentProducerTemplate.class)) {
            return this.createInjectionFluentProducerTemplate(endpointUri, endpointProperty, injectionPointName, bean);
        }
        if (type.isAssignableFrom(ConsumerTemplate.class)) {
            return this.createInjectionConsumerTemplate(endpointUri, endpointProperty, injectionPointName);
        }
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointProperty, injectionPointName, true);
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                return this.createInjectionProducer(endpoint, bean, beanName);
            }
            if (type.isAssignableFrom(PollingConsumer.class)) {
                return this.createInjectionPollingConsumer(endpoint, bean, beanName);
            }
            if (type.isInterface()) {
                try {
                    BeanProxyFactory factory = ((ExtendedCamelContext)endpoint.getCamelContext().adapt(ExtendedCamelContext.class)).getBeanProxyFactory();
                    if (factory == null) {
                        throw new IllegalArgumentException("Cannot find BeanProxyFactory. Make sure camel-bean is on the classpath.");
                    }
                    return factory.createProxy(endpoint, binding, new Class[]{type});
                }
                catch (Exception e) {
                    throw this.createProxyInstantiationRuntimeException(type, endpoint, e);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + type.getName() + " which cannot be injected via @EndpointInject/@Produce for: " + endpoint);
        }
        return null;
    }

    public Object getInjectionPropertyValue(Class<?> type, String propertyName, String propertyDefaultValue, String injectionPointName, Object bean, String beanName) {
        try {
            this.getCamelContext().getPropertiesComponent(true);
            String prefix = "{{";
            String suffix = "}}";
            String key = !propertyName.contains(prefix) ? prefix + propertyName + suffix : propertyName;
            String value = this.getCamelContext().resolvePropertyPlaceholders(key);
            if (value != null) {
                return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, (Object)value);
            }
            return null;
        }
        catch (Exception e) {
            if (ObjectHelper.isNotEmpty((Object)propertyDefaultValue)) {
                try {
                    return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, (Object)propertyDefaultValue);
                }
                catch (Exception e2) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e2);
                }
            }
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public Object getInjectionBeanValue(Class<?> type, String name) {
        if (ObjectHelper.isEmpty((Object)name)) {
            if (type.isAssignableFrom(this.camelContext.getClass())) {
                return this.camelContext;
            }
            Set found = this.getCamelContext().getRegistry().findByType(type);
            if (found == null || found.isEmpty()) {
                throw new NoSuchBeanException(name, type.getName());
            }
            if (found.size() > 1) {
                throw new NoSuchBeanException("Found " + found.size() + " beans of type: " + type + ". Only one bean expected.");
            }
            return found.iterator().next();
        }
        return CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)name, type);
    }

    protected ProducerTemplate createInjectionProducerTemplate(String endpointUri, String endpointProperty, String injectionPointName, Object bean) {
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointProperty, injectionPointName, false);
        CamelContext context = endpoint != null ? endpoint.getCamelContext() : this.getCamelContext();
        DefaultProducerTemplate answer = new DefaultProducerTemplate(context, endpoint);
        try {
            this.startService((Service)answer, context, bean, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected FluentProducerTemplate createInjectionFluentProducerTemplate(String endpointUri, String endpointProperty, String injectionPointName, Object bean) {
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointProperty, injectionPointName, false);
        CamelContext context = endpoint != null ? endpoint.getCamelContext() : this.getCamelContext();
        DefaultFluentProducerTemplate answer = new DefaultFluentProducerTemplate(context);
        answer.setDefaultEndpoint(endpoint);
        try {
            this.startService((Service)answer, context, bean, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected ConsumerTemplate createInjectionConsumerTemplate(String endpointUri, String endpointProperty, String injectionPointName) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this.getCamelContext());
        try {
            this.startService((Service)answer, null, null, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected PollingConsumer createInjectionPollingConsumer(Endpoint endpoint, Object bean, String beanName) {
        try {
            PollingConsumer consumer = endpoint.createPollingConsumer();
            this.startService((Service)consumer, endpoint.getCamelContext(), bean, beanName);
            return consumer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected Producer createInjectionProducer(Endpoint endpoint, Object bean, String beanName) {
        try {
            return ((ExtendedCamelContext)endpoint.getCamelContext().adapt(ExtendedCamelContext.class)).getDeferServiceFactory().createProducer(endpoint);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
        return new ProxyInstantiationException(type, endpoint, (Throwable)e);
    }

    protected boolean isSingleton(Object bean, String beanName) {
        if (bean instanceof IsSingleton) {
            IsSingleton singleton = (IsSingleton)bean;
            return singleton.isSingleton();
        }
        return true;
    }
}

