/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.engine.DefaultConsumerCache;
import org.apache.camel.spi.ConsumerCache;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;

public class DefaultConsumerTemplate
extends ServiceSupport
implements ConsumerTemplate {
    private final CamelContext camelContext;
    private ConsumerCache consumerCache;
    private int maximumCacheSize;

    public DefaultConsumerTemplate(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    public int getCurrentCacheSize() {
        if (this.consumerCache == null) {
            return 0;
        }
        return this.consumerCache.size();
    }

    public void cleanUp() {
        if (this.consumerCache != null) {
            this.consumerCache.cleanUp();
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Exchange receive(String endpointUri) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receive(endpoint);
    }

    public Exchange receive(Endpoint endpoint) {
        return this.receive(endpoint.getEndpointUri());
    }

    public Exchange receive(String endpointUri, long timeout) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receive(endpoint, timeout);
    }

    public Exchange receive(Endpoint endpoint, long timeout) {
        return this.receive(endpoint.getEndpointUri(), timeout);
    }

    public Exchange receiveNoWait(String endpointUri) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receiveNoWait(endpoint);
    }

    public Exchange receiveNoWait(Endpoint endpoint) {
        return this.receiveNoWait(endpoint.getEndpointUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receiveBody(String endpointUri) {
        Object answer = null;
        Exchange exchange = this.receive(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
        }
        finally {
            this.doneUoW(exchange);
        }
        return answer;
    }

    public Object receiveBody(Endpoint endpoint) {
        return this.receiveBody(endpoint.getEndpointUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receiveBody(String endpointUri, long timeout) {
        Object answer = null;
        Exchange exchange = this.receive(endpointUri, timeout);
        try {
            answer = this.extractResultBody(exchange);
        }
        finally {
            this.doneUoW(exchange);
        }
        return answer;
    }

    public Object receiveBody(Endpoint endpoint, long timeout) {
        return this.receiveBody(endpoint.getEndpointUri(), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receiveBodyNoWait(String endpointUri) {
        Object answer = null;
        Exchange exchange = this.receiveNoWait(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
        }
        finally {
            this.doneUoW(exchange);
        }
        return answer;
    }

    public Object receiveBodyNoWait(Endpoint endpoint) {
        return this.receiveBodyNoWait(endpoint.getEndpointUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T receiveBody(String endpointUri, Class<T> type) {
        Object answer = null;
        Exchange exchange = this.receive(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.camelContext.getTypeConverter().convertTo(type, exchange, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    public <T> T receiveBody(Endpoint endpoint, Class<T> type) {
        return this.receiveBody(endpoint.getEndpointUri(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T receiveBody(String endpointUri, long timeout, Class<T> type) {
        Object answer = null;
        Exchange exchange = this.receive(endpointUri, timeout);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.camelContext.getTypeConverter().convertTo(type, exchange, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    public <T> T receiveBody(Endpoint endpoint, long timeout, Class<T> type) {
        return this.receiveBody(endpoint.getEndpointUri(), timeout, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T receiveBodyNoWait(String endpointUri, Class<T> type) {
        Object answer = null;
        Exchange exchange = this.receiveNoWait(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.camelContext.getTypeConverter().convertTo(type, exchange, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    public <T> T receiveBodyNoWait(Endpoint endpoint, Class<T> type) {
        return this.receiveBodyNoWait(endpoint.getEndpointUri(), type);
    }

    public void doneUoW(Exchange exchange) {
        try {
            if (exchange == null) {
                return;
            }
            if (exchange.getUnitOfWork() == null) {
                List synchronizations = exchange.handoverCompletions();
                UnitOfWorkHelper.doneSynchronizations((Exchange)exchange, (List)synchronizations, (Logger)this.log);
            } else {
                exchange.getUnitOfWork().done(exchange);
            }
        }
        catch (Throwable e) {
            this.log.warn("Exception occurred during done UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
    }

    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        return CamelContextHelper.getMandatoryEndpoint((CamelContext)this.camelContext, (String)endpointUri);
    }

    protected Object extractResultBody(Exchange result) {
        Object answer = null;
        if (result != null) {
            if (result.getException() != null) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)result.getException());
            }
            answer = result.getMessage().getBody();
        }
        return answer;
    }

    private ConsumerCache getConsumerCache() {
        if (!this.isStarted()) {
            throw new IllegalStateException("ConsumerTemplate has not been started");
        }
        return this.consumerCache;
    }

    protected void doStart() throws Exception {
        if (this.consumerCache == null) {
            this.consumerCache = new DefaultConsumerCache((Object)this, this.camelContext, this.maximumCacheSize);
        }
        ServiceHelper.startService((Object)this.consumerCache);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.consumerCache);
        this.consumerCache = null;
    }
}

