/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.transformer;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class DataFormatTransformer
extends Transformer {
    private DataFormat dataFormat;
    private String transformerString;

    public DataFormatTransformer(CamelContext context) {
        this.setCamelContext(context);
    }

    public void transform(Message message, DataType from, DataType to) throws Exception {
        Exchange exchange = message.getExchange();
        CamelContext context = exchange.getContext();
        if ((to == null || to.isJavaType()) && (from.equals((Object)this.getFrom()) || from.getModel().equals(this.getModel()))) {
            Class toClass;
            this.log.debug("Unmarshaling with '{}'", (Object)this.dataFormat);
            Object answer = this.dataFormat.unmarshal(exchange, (InputStream)message.getBody(InputStream.class));
            if (to != null && to.getName() != null && !(toClass = context.getClassResolver().resolveClass(to.getName())).isAssignableFrom(answer.getClass())) {
                this.log.debug("Converting to '{}'", (Object)toClass.getName());
                answer = context.getTypeConverter().mandatoryConvertTo(toClass, answer);
            }
            message.setBody(answer);
        } else if ((from == null || from.isJavaType()) && (to.equals((Object)this.getTo()) || to.getModel().equals(this.getModel()))) {
            Class fromClass;
            Object input = message.getBody();
            if (from != null && from.getName() != null && !(fromClass = context.getClassResolver().resolveClass(from.getName())).isAssignableFrom(input.getClass())) {
                this.log.debug("Converting to '{}'", (Object)fromClass.getName());
                input = context.getTypeConverter().mandatoryConvertTo(fromClass, input);
            }
            OutputStreamBuilder osb = OutputStreamBuilder.withExchange((Exchange)exchange);
            this.log.debug("Marshaling with '{}'", (Object)this.dataFormat);
            this.dataFormat.marshal(exchange, message.getBody(), (OutputStream)osb);
            message.setBody(osb.build());
        } else {
            throw new IllegalArgumentException("Unsupported transformation: from='" + from + ", to='" + to + "'");
        }
    }

    public DataFormatTransformer setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
        this.transformerString = null;
        return this;
    }

    public String toString() {
        if (this.transformerString == null) {
            this.transformerString = String.format("DataFormatTransformer[scheme='%s', from='%s', to='%s', dataFormat='%s']", this.getModel(), this.getFrom(), this.getTo(), this.dataFormat);
        }
        return this.transformerString;
    }

    public void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.dataFormat, (String)"dataFormat");
        this.getCamelContext().addService((Object)this.dataFormat, false);
    }

    public void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.dataFormat);
        this.getCamelContext().removeService((Object)this.dataFormat);
    }
}

