/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.impl.engine.DefaultClaimCheckRepository;
import org.apache.camel.processor.ClaimCheckAggregationStrategy;
import org.apache.camel.spi.ClaimCheckRepository;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class ClaimCheckProcessor
extends AsyncProcessorSupport
implements IdAware,
CamelContextAware {
    private CamelContext camelContext;
    private String id;
    private String operation;
    private AggregationStrategy aggregationStrategy;
    private String key;
    private Expression keyExpression;
    private String filter;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        ClaimCheckRepository repo = (ClaimCheckRepository)exchange.getProperty("CamelClaimCheckRepository", ClaimCheckRepository.class);
        if (repo == null) {
            repo = new DefaultClaimCheckRepository();
            exchange.setProperty("CamelClaimCheckRepository", (Object)repo);
        }
        try {
            String claimKey = (String)this.keyExpression.evaluate(exchange, String.class);
            if ("Set".equals(this.operation)) {
                Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
                boolean addedNew = repo.add(claimKey, copy);
                if (addedNew) {
                    this.log.debug("Add: {} -> {}", (Object)claimKey, (Object)copy);
                } else {
                    this.log.debug("Override: {} -> {}", (Object)claimKey, (Object)copy);
                }
            } else if ("Get".equals(this.operation)) {
                Exchange result;
                Exchange copy = repo.get(claimKey);
                this.log.debug("Get: {} -> {}", (Object)claimKey, (Object)exchange);
                if (copy != null && (result = this.aggregationStrategy.aggregate(exchange, copy)) != null) {
                    ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)result);
                }
            } else if ("GetAndRemove".equals(this.operation)) {
                Exchange copy = repo.getAndRemove(claimKey);
                this.log.debug("GetAndRemove: {} -> {}", (Object)claimKey, (Object)exchange);
                if (copy != null) {
                    ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)copy);
                    Exchange result = this.aggregationStrategy.aggregate(exchange, copy);
                    if (result != null) {
                        ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)result);
                    }
                }
            } else if ("Push".equals(this.operation)) {
                Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
                this.log.debug("Push: {} -> {}", (Object)claimKey, (Object)copy);
                repo.push(copy);
            } else if ("Pop".equals(this.operation)) {
                Exchange copy = repo.pop();
                this.log.debug("Pop: {} -> {}", (Object)claimKey, (Object)exchange);
                if (copy != null) {
                    ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)copy);
                    Exchange result = this.aggregationStrategy.aggregate(exchange, copy);
                    if (result != null) {
                        ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)result);
                    }
                }
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.operation, (String)"operation", (Object)((Object)this));
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = this.createAggregationStrategy();
        }
        if (this.aggregationStrategy instanceof CamelContextAware) {
            ((CamelContextAware)this.aggregationStrategy).setCamelContext(this.camelContext);
        }
        this.keyExpression = LanguageSupport.hasSimpleFunction((String)this.key) ? this.camelContext.resolveLanguage("simple").createExpression(this.key) : this.camelContext.resolveLanguage("constant").createExpression(this.key);
        ServiceHelper.startService((Object)this.aggregationStrategy);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.aggregationStrategy);
    }

    public String toString() {
        return "ClaimCheck[" + this.operation + "]";
    }

    protected AggregationStrategy createAggregationStrategy() {
        ClaimCheckAggregationStrategy answer = new ClaimCheckAggregationStrategy();
        answer.setFilter(this.filter);
        return answer;
    }
}

