/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.service.ServiceHelper;

public class FilterProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware {
    private String id;
    private final Predicate predicate;
    private transient long filtered;

    public FilterProcessor(Predicate predicate, Processor processor) {
        super(processor);
        this.predicate = predicate;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean matches = false;
        try {
            matches = this.matches(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (matches) {
            return this.processor.process(exchange, callback);
        }
        callback.done(true);
        return true;
    }

    public boolean matches(Exchange exchange) {
        boolean matches = this.predicate.matches(exchange);
        this.log.debug("Filter matches: {} for exchange: {}", (Object)matches, (Object)exchange);
        exchange.setProperty("CamelFilterMatched", (Object)matches);
        if (matches) {
            ++this.filtered;
        }
        return matches;
    }

    public String toString() {
        return "Filter[if: " + this.predicate + " do: " + this.getProcessor() + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTraceLabel() {
        return "filter[if: " + this.predicate + "]";
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public long getFilteredCount() {
        return this.filtered;
    }

    public void reset() {
        this.filtered = 0L;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.reset();
        ServiceHelper.startService((Object)this.predicate);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.predicate);
        super.doStop();
    }
}

