/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.util.ObjectHelper;

public class SetHeaderProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware {
    private String id;
    private final Expression headerName;
    private final Expression expression;

    public SetHeaderProcessor(Expression headerName, Expression expression) {
        this.headerName = headerName;
        this.expression = expression;
        ObjectHelper.notNull((Object)headerName, (String)"headerName");
        ObjectHelper.notNull((Object)expression, (String)"expression");
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object newHeader = this.expression.evaluate(exchange, Object.class);
            if (exchange.getException() != null) {
                callback.done(true);
                return true;
            }
            Message old = exchange.getMessage();
            String key = (String)this.headerName.evaluate(exchange, String.class);
            old.setHeader(key, newHeader);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "SetHeader(" + this.headerName + ", " + this.expression + ")";
    }

    public String getTraceLabel() {
        return "setHeader[" + this.headerName + ", " + this.expression + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHeaderName() {
        return this.headerName.toString();
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

