/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.TypeConverter;
import org.apache.camel.blueprint.BlueprintComponentResolver;
import org.apache.camel.blueprint.BlueprintContainerRegistry;
import org.apache.camel.blueprint.BlueprintDataFormatResolver;
import org.apache.camel.blueprint.BlueprintLanguageResolver;
import org.apache.camel.blueprint.BlueprintModelJAXBContextFactory;
import org.apache.camel.blueprint.handler.CamelNamespaceHandler;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiCamelContextPublisher;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiTypeConverter;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.LoadPropertiesException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintCamelContext
extends DefaultCamelContext
implements ServiceListener,
BlueprintListener {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintCamelContext.class);
    protected final AtomicBoolean routeDefinitionValid = new AtomicBoolean(true);
    private BundleContext bundleContext;
    private BlueprintContainer blueprintContainer;
    private ServiceRegistration<?> registration;

    public BlueprintCamelContext() {
    }

    public BlueprintCamelContext(BundleContext bundleContext, BlueprintContainer blueprintContainer) {
        this.bundleContext = bundleContext;
        this.blueprintContainer = blueprintContainer;
        OsgiCamelContextHelper.osgiUpdate(this, bundleContext);
        this.setComponentResolver(new BlueprintComponentResolver(bundleContext));
        this.setLanguageResolver(new BlueprintLanguageResolver(bundleContext));
        this.setDataFormatResolver(new BlueprintDataFormatResolver(bundleContext));
        this.setApplicationContextClassLoader(new BundleDelegatingClassLoader(bundleContext.getBundle()));
    }

    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        return new BlueprintModelJAXBContextFactory(CamelNamespaceHandler.class.getClassLoader());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void init() throws Exception {
        LOG.trace("init {}", (Object)this);
        this.bundleContext.addServiceListener((ServiceListener)this);
        this.registration = this.bundleContext.registerService(BlueprintListener.class, (Object)this, null);
    }

    public void destroy() throws Exception {
        LOG.trace("destroy {}", (Object)this);
        try {
            this.bundleContext.removeServiceListener((ServiceListener)this);
        }
        catch (Exception e) {
            LOG.warn("Error removing ServiceListener " + (Object)((Object)this) + ". This exception is ignored.", (Throwable)e);
        }
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (Exception e) {
                LOG.warn("Error unregistering service registration " + this.registration + ". This exception is ignored.", (Throwable)e);
            }
            this.registration = null;
        }
        this.stop();
    }

    public Map<String, Properties> findComponents() throws LoadPropertiesException, IOException {
        return BundleContextUtils.findComponents(this.bundleContext, (CamelContext)this);
    }

    public String getComponentDocumentation(String componentName) throws IOException {
        return BundleContextUtils.getComponentDocumentation(this.bundleContext, (CamelContext)this, componentName);
    }

    public void blueprintEvent(BlueprintEvent event) {
    }

    public void serviceChanged(ServiceEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service {} changed to {}", (Object)event, (Object)event.getType());
        }
        if (event.getType() == 1 && event.getServiceReference().isAssignableTo(this.bundleContext.getBundle(), "org.osgi.service.blueprint.container.BlueprintContainer") && this.bundleContext.getBundle().equals(event.getServiceReference().getBundle())) {
            try {
                this.maybeStart();
            }
            catch (Exception e) {
                LOG.error("Error occurred during starting Camel: " + (Object)((Object)this) + " due " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(((Object)((Object)this)).getClass());
        if (ctx == null) {
            ctx = this.bundleContext;
        }
        FactoryFinder finder = new OsgiFactoryFinderResolver(this.bundleContext).resolveDefaultFactoryFinder(this.getClassResolver());
        return new OsgiTypeConverter(ctx, (CamelContext)this, this.getInjector(), finder);
    }

    protected Registry createRegistry() {
        BlueprintContainerRegistry reg = new BlueprintContainerRegistry(this.getBlueprintContainer());
        return OsgiCamelContextHelper.wrapRegistry((CamelContext)this, reg, this.bundleContext);
    }

    public void start() throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getApplicationContextClassLoader());
            super.start();
        }
        catch (FailedToCreateRouteException e) {
            this.routeDefinitionValid.set(false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private void maybeStart() throws Exception {
        boolean skip;
        LOG.trace("maybeStart: {}", (Object)this);
        if (!this.routeDefinitionValid.get()) {
            LOG.trace("maybeStart: {} is skipping since CamelRoute definition is not correct.", (Object)this);
            return;
        }
        boolean eager = "true".equalsIgnoreCase(System.getProperty("registerBlueprintCamelContextEager"));
        if (eager) {
            for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
                if (!(notifier instanceof OsgiCamelContextPublisher)) continue;
                OsgiCamelContextPublisher publisher = (OsgiCamelContextPublisher)notifier;
                publisher.registerCamelContext((CamelContext)this);
                break;
            }
        }
        if (skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"))) {
            LOG.trace("maybeStart: {} is skipping as System property skipStartingCamelContext is set", (Object)this);
            return;
        }
        if (!this.isStarted() && !this.isStarting()) {
            LOG.debug("Starting {}", (Object)this);
            this.start();
        } else {
            LOG.trace("Ignoring maybeStart() as {} is already started", (Object)this);
        }
    }
}

