/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.sdk.BoxAPIConnection;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.box.BoxComponent;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.BoxConsumer;
import org.apache.camel.component.box.BoxProducer;
import org.apache.camel.component.box.api.BoxCollaborationsManager;
import org.apache.camel.component.box.api.BoxCommentsManager;
import org.apache.camel.component.box.api.BoxEventLogsManager;
import org.apache.camel.component.box.api.BoxEventsManager;
import org.apache.camel.component.box.api.BoxFilesManager;
import org.apache.camel.component.box.api.BoxFoldersManager;
import org.apache.camel.component.box.api.BoxGroupsManager;
import org.apache.camel.component.box.api.BoxSearchManager;
import org.apache.camel.component.box.api.BoxTasksManager;
import org.apache.camel.component.box.api.BoxUsersManager;
import org.apache.camel.component.box.internal.BoxApiCollection;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.component.box.internal.BoxConnectionHelper;
import org.apache.camel.component.box.internal.BoxPropertiesHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;

@UriEndpoint(firstVersion="2.14.0", scheme="box", title="Box", syntax="box:apiName/methodName", apiSyntax="apiName/methodName", consumerPrefix="consumer", category={Category.CLOUD, Category.FILE, Category.API}, lenientProperties=true)
@Metadata(excludeProperties="startScheduler,initialDelay,delay,timeUnit,useFixedDelay,pollStrategy,runLoggingLevel,sendEmptyMessageWhenIdle,greedy,scheduler,schedulerProperties,scheduledExecutorService,backoffMultiplier,backoffIdleThreshold,backoffErrorThreshold,repeatCount,bridgeErrorHandler")
public class BoxEndpoint
extends AbstractApiEndpoint<BoxApiName, BoxConfiguration> {
    @UriParam
    private BoxConfiguration configuration;
    private BoxAPIConnection boxConnection;
    private Object apiProxy;
    private boolean boxConnectionShared;

    public BoxEndpoint(String uri, BoxComponent component, BoxApiName apiName, String methodName, BoxConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, BoxApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public BoxComponent getComponent() {
        return (BoxComponent)super.getComponent();
    }

    public BoxAPIConnection getBoxConnection() {
        return this.boxConnection;
    }

    public Producer createProducer() throws Exception {
        return new BoxProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        BoxConsumer consumer = new BoxConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<BoxConfiguration> getPropertiesHelper() {
        return BoxPropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelBox";
    }

    protected void afterConfigureProperties() {
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        if (this.apiProxy == null) {
            this.createApiProxy();
        }
        return this.apiProxy;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.createBoxConnection();
    }

    private void createBoxConnection() {
        BoxComponent component = this.getComponent();
        this.boxConnectionShared = this.configuration.equals(this.getComponent().getConfiguration());
        this.boxConnection = this.boxConnectionShared ? component.getBoxConnection() : BoxConnectionHelper.createConnection(this.configuration);
    }

    private void createApiProxy() {
        switch ((BoxApiName)this.apiName) {
            case COLLABORATIONS: {
                this.apiProxy = new BoxCollaborationsManager(this.getBoxConnection());
                break;
            }
            case COMMENTS: {
                this.apiProxy = new BoxCommentsManager(this.getBoxConnection());
                break;
            }
            case EVENT_LOGS: {
                this.apiProxy = new BoxEventLogsManager(this.getBoxConnection());
                break;
            }
            case EVENTS: {
                this.apiProxy = new BoxEventsManager(this.getBoxConnection());
                break;
            }
            case FILES: {
                this.apiProxy = new BoxFilesManager(this.getBoxConnection());
                break;
            }
            case FOLDERS: {
                this.apiProxy = new BoxFoldersManager(this.getBoxConnection());
                break;
            }
            case GROUPS: {
                this.apiProxy = new BoxGroupsManager(this.getBoxConnection());
                break;
            }
            case SEARCH: {
                this.apiProxy = new BoxSearchManager(this.getBoxConnection());
                break;
            }
            case TASKS: {
                this.apiProxy = new BoxTasksManager(this.getBoxConnection());
                break;
            }
            case USERS: {
                this.apiProxy = new BoxUsersManager(this.getBoxConnection());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + this.apiName);
            }
        }
    }
}

