/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.lucene;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Set;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.PlainTextDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;

public class LuceneSuggestionStrategy
implements SuggestionStrategy {
    private int maxSuggestions = 3;

    public String[] suggestEndpointOptions(Set<String> names, String unknownOption) {
        return LuceneSuggestionStrategy.suggestEndpointOptions(names, unknownOption, this.maxSuggestions);
    }

    public static String[] suggestEndpointOptions(Collection<String> names, String unknownOption, int maxSuggestions) {
        String[] stringArray;
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append(name);
            sb.append("\n");
        }
        StringReader reader = new StringReader(sb.toString());
        PlainTextDictionary words = new PlainTextDictionary((Reader)reader);
        ByteBuffersDirectory dir = new ByteBuffersDirectory();
        try {
            SpellChecker checker = new SpellChecker((Directory)dir);
            checker.indexDictionary((Dictionary)words, new IndexWriterConfig((Analyzer)new KeywordAnalyzer()), false);
            stringArray = checker.suggestSimilar(unknownOption, maxSuggestions);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dir.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return new String[0];
            }
        }
        dir.close();
        return stringArray;
    }
}

