/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cdi.CdiCamelContext;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.util.ObjectHelper;

public class CamelContextConfig {
    private final Set<Bean<?>> routeBuilderBeans = new LinkedHashSet();
    private final Set<ProcessAnnotatedType<?>> patRouteBuilders = new LinkedHashSet();

    public void addRouteBuilderBean(Bean<?> bean) {
        this.routeBuilderBeans.add(bean);
    }

    public void configure(CdiCamelContext camelContext, BeanManager beanManager) {
        for (ProcessAnnotatedType<?> processAnnotatedType : this.patRouteBuilders) {
            Set beans = beanManager.getBeans((Type)processAnnotatedType.getAnnotatedType().getJavaClass(), new Annotation[0]);
            Bean bean = beanManager.resolve(beans);
            this.routeBuilderBeans.add(bean);
        }
        this.patRouteBuilders.clear();
        for (Bean bean : this.routeBuilderBeans) {
            CreationalContext createContext = beanManager.createCreationalContext((Contextual)bean);
            Class beanClass = bean.getBeanClass();
            Set types = bean.getTypes();
            for (Type type : types) {
                if (!(type instanceof Class)) continue;
                beanClass = (Class)type;
                break;
            }
            Object reference = beanManager.getReference(bean, (Type)beanClass, createContext);
            ObjectHelper.notNull((Object)reference, (String)("Could not instantiate bean of type " + beanClass.getName() + " for " + bean));
            try {
                if (reference instanceof RoutesBuilder) {
                    RoutesBuilder routeBuilder = (RoutesBuilder)reference;
                    camelContext.addRoutes(routeBuilder);
                    continue;
                }
                if (reference instanceof RouteContainer) {
                    RouteContainer routeContainer = (RouteContainer)reference;
                    camelContext.addRouteDefinitions(routeContainer.getRoutes());
                    continue;
                }
                throw new IllegalArgumentException("Invalid route builder " + reference + " of type " + beanClass.getName() + ". Should be RoutesBuilder or RoutesContainer");
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Could not add " + reference + " to CamelContext: " + (Object)((Object)camelContext) + ". Reason: " + e, (Throwable)e);
            }
        }
    }

    public void addRouteBuilderBean(ProcessAnnotatedType<?> process) {
        this.patRouteBuilders.add(process);
    }
}

