/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cloudevents.transformer;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvent;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="http:application-cloudevents", description="Adds default CloudEvent (HTTP binding) headers to the Camel message (such as content-type, event source, event type etc.)")
public class CloudEventHttpDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventID").http(), headers.getOrDefault("CamelCloudEventID", message.getExchange().getExchangeId()));
        headers.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventVersion").http(), headers.getOrDefault("CamelCloudEventVersion", cloudEvent.version()));
        headers.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventType").http(), headers.getOrDefault("CamelCloudEventType", "org.apache.camel.event"));
        headers.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventSource").http(), headers.getOrDefault("CamelCloudEventSource", "org.apache.camel"));
        if (headers.containsKey("CamelCloudEventSubject")) {
            headers.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventSubject").http(), headers.get("CamelCloudEventSubject"));
        }
        if (headers.containsKey("CamelCloudEventDataContentType")) {
            headers.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventDataContentType").http(), headers.get("CamelCloudEventDataContentType"));
        }
        headers.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventTime").http(), headers.getOrDefault("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange())));
        headers.putIfAbsent("Content-Type", headers.getOrDefault("Content-Type", "application/json"));
        cloudEvent.attributes().stream().map(CloudEvent.Attribute::id).forEach(headers::remove);
    }
}

