/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.http.jakarta.CometDServlet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.resource.MountedPathResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="cometd,cometds")
public class CometdComponent
extends DefaultComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(CometdComponent.class);
    private final Map<String, ConnectorRef> connectors = new LinkedHashMap<String, ConnectorRef>();
    private List<BayeuxServer.BayeuxServerListener> serverListeners;
    @Metadata(label="security", secret=true)
    private String sslKeyPassword;
    @Metadata(label="security", secret=true)
    private String sslPassword;
    @Metadata(label="security", secret=true)
    private String sslKeystore;
    @Metadata(label="security")
    private SecurityPolicy securityPolicy;
    @Metadata(label="advanced")
    private List<BayeuxServer.Extension> extensions;
    @Metadata(label="security")
    private SSLContextParameters sslContextParameters;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CometdEndpoint endpoint = new CometdEndpoint(this, uri, remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(CometdProducerConsumer prodcon) throws Exception {
        Server server = null;
        CometdEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getUri().getHost() + ":" + endpoint.getPort();
        Map<String, ConnectorRef> map = this.connectors;
        synchronized (map) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef == null) {
                server = this.createServer();
                ServerConnector connector = "cometds".equals(endpoint.getProtocol()) ? this.getSslSocketConnector(server) : new ServerConnector(server);
                connector.setPort(endpoint.getPort());
                connector.setHost(endpoint.getUri().getHost());
                if ("localhost".equalsIgnoreCase(endpoint.getUri().getHost())) {
                    LOG.warn("You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)?");
                }
                server.addConnector((Connector)connector);
                CometDServlet servlet = this.createServletForConnector(server, endpoint);
                connectorRef = new ConnectorRef((Connector)connector, servlet, server);
                server.start();
                this.connectors.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
            BayeuxServerImpl bayeux = (BayeuxServerImpl)connectorRef.servlet.getBayeuxServer();
            if (this.securityPolicy != null) {
                bayeux.setSecurityPolicy(this.securityPolicy);
            }
            if (this.extensions != null) {
                for (BayeuxServer.Extension extension : this.extensions) {
                    bayeux.addExtension(extension);
                }
            }
            if (this.serverListeners != null) {
                for (BayeuxServer.BayeuxServerListener serverListener : this.serverListeners) {
                    bayeux.addListener(serverListener);
                }
            }
            prodcon.setBayeux(bayeux);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(CometdProducerConsumer prodcon) throws Exception {
        CometdEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getUri().getHost() + ":" + endpoint.getPort();
        Map<String, ConnectorRef> map = this.connectors;
        synchronized (map) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null && connectorRef.decrement() == 0) {
                connectorRef.server.removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                connectorRef.server.stop();
                this.connectors.remove(connectorKey);
            }
        }
    }

    protected CometDServlet createServletForConnector(Server server, CometdEndpoint endpoint) throws Exception {
        CometDServlet servlet = new CometDServlet();
        ServletContextHandler context = new ServletContextHandler("/", false, false);
        server.setHandler((Handler)context);
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)servlet);
        holder.setAsyncSupported(true);
        if (endpoint.getBaseResource() != null) {
            String[] resources = endpoint.getBaseResource().split(":");
            LOG.debug(">>> Protocol found: {}, and resource: {}", (Object)resources[0], (Object)resources[1]);
            if (resources[0].equals("file")) {
                context.setBaseResource(new MountedPathResourceFactory().newResource(resources[1]));
            } else if (resources[0].equals("classpath")) {
                URL url = this.getCamelContext().getClassResolver().loadResourceAsURL(resources[1]);
                context.setBaseResource(new MountedPathResourceFactory().newResource(url));
            }
        }
        this.applyCrossOriginFiltering(endpoint, context);
        context.addServlet(holder, "/cometd/*");
        context.addServlet("org.eclipse.jetty.ee10.servlet.DefaultServlet", "/");
        context.setSessionHandler(new SessionHandler());
        holder.setInitParameter("timeout", Integer.toString(endpoint.getTimeout()));
        holder.setInitParameter("interval", Integer.toString(endpoint.getInterval()));
        holder.setInitParameter("maxInterval", Integer.toString(endpoint.getMaxInterval()));
        holder.setInitParameter("multiFrameInterval", Integer.toString(endpoint.getMultiFrameInterval()));
        holder.setInitParameter("JSONCommented", Boolean.toString(endpoint.isJsonCommented()));
        holder.setInitParameter("logLevel", Integer.toString(endpoint.getLogLevel()));
        return servlet;
    }

    protected ServerConnector getSslSocketConnector(Server server) throws Exception {
        ServerConnector sslSocketConnector = null;
        SSLContextParameters sslParams = this.sslContextParameters;
        if (sslParams == null) {
            sslParams = this.retrieveGlobalSslContextParameters();
        }
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setEndpointIdentificationAlgorithm(null);
        if (sslParams != null) {
            sslContextFactory.setSslContext(sslParams.createSSLContext(this.getCamelContext()));
        } else {
            sslContextFactory.setKeyStorePassword(this.sslKeyPassword);
            sslContextFactory.setKeyManagerPassword(this.sslPassword);
            if (this.sslKeystore != null) {
                sslContextFactory.setKeyStorePath(this.sslKeystore);
            }
        }
        sslSocketConnector = new ServerConnector(server, sslContextFactory);
        return sslSocketConnector;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public List<BayeuxServer.Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<BayeuxServer.Extension> extensions) {
        this.extensions = extensions;
    }

    public void addExtension(BayeuxServer.Extension extension) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<BayeuxServer.Extension>();
        }
        this.extensions.add(extension);
    }

    public void addServerListener(BayeuxServer.BayeuxServerListener serverListener) {
        if (this.serverListeners == null) {
            this.serverListeners = new ArrayList<BayeuxServer.BayeuxServerListener>();
        }
        this.serverListeners.add(serverListener);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    protected Server createServer() {
        Server server = new Server();
        ContextHandlerCollection collection = new ContextHandlerCollection(new ContextHandler[0]);
        server.setHandler((Handler)collection);
        return server;
    }

    protected void doStop() throws Exception {
        for (ConnectorRef connectorRef : this.connectors.values()) {
            connectorRef.connector.stop();
        }
        this.connectors.clear();
        super.doStop();
    }

    private void applyCrossOriginFiltering(CometdEndpoint endpoint, ServletContextHandler context) {
        if (endpoint.isCrossOriginFilterOn()) {
            FilterHolder filterHolder = new FilterHolder();
            CrossOriginFilter filter = new CrossOriginFilter();
            filterHolder.setFilter((Filter)filter);
            filterHolder.setInitParameter("allowedOrigins", endpoint.getAllowedOrigins());
            context.addFilter(filterHolder, endpoint.getFilterPath(), EnumSet.allOf(DispatcherType.class));
        }
    }

    static class ConnectorRef {
        Connector connector;
        CometDServlet servlet;
        Server server;
        int refCount;

        ConnectorRef(Connector connector, CometDServlet servlet, Server server) {
            this.connector = connector;
            this.servlet = servlet;
            this.server = server;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }
    }
}

