/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.console.DevConsole;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.annotations.DevConsole;

@DevConsole(value="context")
public class ContextDevConsole
extends AbstractDevConsole {
    public ContextDevConsole() {
        super("camel", "context", "CamelContext", "Overall information about the CamelContext");
    }

    @Override
    protected Object doCall(DevConsole.MediaType mediaType, Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Apache Camel %s (%s) uptime %s", this.getCamelContext().getVersion(), this.getCamelContext().getName(), this.getCamelContext().getUptime()));
        sb.append("\n");
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getExtension(ManagedCamelContext.class);
        if (mcc != null) {
            ManagedCamelContextMBean mb = mcc.getManagedCamelContext();
            sb.append(String.format("\n    Total: %s", mb.getExchangesTotal()));
            sb.append(String.format("\n    Failed: %s", mb.getExchangesFailed()));
            sb.append(String.format("\n    Inflight: %s", mb.getExchangesInflight()));
            sb.append("\n");
        }
        return sb.toString();
    }
}

