/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import org.apache.camel.console.DevConsole;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.EventNotifierSupport;

@DevConsole(value="event")
@Configurer(bootstrap=true)
public class EventConsole
extends AbstractDevConsole {
    @Metadata(defaultValue="25", description="Maximum capacity of last number of events to capture")
    private int capacity = 25;
    private Queue<CamelEvent> events;
    private Queue<CamelEvent.ExchangeEvent> exchangeEvents;
    private final ConsoleEventNotifier listener = new ConsoleEventNotifier();

    public EventConsole() {
        super("camel", "event", "Camel Events", "The most recent Camel events");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    protected void doInit() throws Exception {
        this.events = new ArrayDeque<CamelEvent>(this.capacity);
        this.exchangeEvents = new ArrayDeque<CamelEvent.ExchangeEvent>(this.capacity);
    }

    protected void doStart() throws Exception {
        this.getCamelContext().getManagementStrategy().addEventNotifier((EventNotifier)this.listener);
    }

    protected void doStop() throws Exception {
        this.getCamelContext().getManagementStrategy().removeEventNotifier((EventNotifier)this.listener);
        this.events.clear();
    }

    @Override
    protected Object doCall(DevConsole.MediaType mediaType, Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (!this.events.isEmpty()) {
            sb.append(String.format("Last %s Camel Events:", this.events.size()));
            for (CamelEvent camelEvent : this.events) {
                sb.append(String.format("\n    %s", camelEvent));
            }
            sb.append("\n");
        }
        if (!this.exchangeEvents.isEmpty()) {
            sb.append("\n");
            sb.append(String.format("Last %s Exchange Events:", this.exchangeEvents.size()));
            for (CamelEvent.ExchangeEvent exchangeEvent : this.exchangeEvents) {
                sb.append(String.format("\n    %s", exchangeEvent));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private class ConsoleEventNotifier
    extends EventNotifierSupport {
        private ConsoleEventNotifier() {
        }

        public void notify(CamelEvent event) throws Exception {
            if (event instanceof CamelEvent.ExchangeEvent) {
                if (EventConsole.this.exchangeEvents.size() >= EventConsole.this.capacity) {
                    EventConsole.this.exchangeEvents.poll();
                }
                EventConsole.this.exchangeEvents.add((CamelEvent.ExchangeEvent)event);
            } else {
                if (EventConsole.this.events.size() >= EventConsole.this.capacity) {
                    EventConsole.this.events.poll();
                }
                EventConsole.this.events.offer(event);
            }
        }
    }
}

