/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="route")
public class RouteDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";

    public RouteDevConsole() {
        super("camel", "route", "Route", "Route information");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(String.format("    Id: %s", mrb.getRouteId()));
            sb.append(String.format("\n    From: %s", mrb.getEndpointUri()));
            if (mrb.getSourceLocation() != null) {
                sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
            }
            sb.append(String.format("\n    State: %s", mrb.getState()));
            sb.append(String.format("\n    Uptime: %s", mrb.getUptime()));
            sb.append(String.format("\n    Total: %s", mrb.getExchangesTotal()));
            sb.append(String.format("\n    Failed: %s", mrb.getExchangesFailed()));
            sb.append(String.format("\n    Inflight: %s", mrb.getExchangesInflight()));
            sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration((long)mrb.getMeanProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration((long)mrb.getMaxProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration((long)mrb.getMinProcessingTime(), (boolean)true)));
            sb.append("\n");
            return null;
        };
        this.doCall(options, task);
        return sb.toString();
    }

    @Override
    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            JsonObject jo = new JsonObject();
            list.add(jo);
            jo.put((Object)"routeId", (Object)mrb.getRouteId());
            jo.put((Object)"from", (Object)mrb.getEndpointUri());
            if (mrb.getSourceLocation() != null) {
                jo.put((Object)"source", (Object)mrb.getSourceLocation());
            }
            jo.put((Object)"state", (Object)mrb.getState());
            jo.put((Object)"uptime", (Object)mrb.getUptime());
            JsonObject stats = new JsonObject();
            stats.put((Object)"exchangesTotal", (Object)mrb.getExchangesTotal());
            stats.put((Object)"exchangesFailed", (Object)mrb.getExchangesFailed());
            stats.put((Object)"exchangesInflight", (Object)mrb.getExchangesInflight());
            stats.put((Object)"meanProcessingTime", (Object)mrb.getMeanProcessingTime());
            stats.put((Object)"maxProcessingTime", (Object)mrb.getMaxProcessingTime());
            stats.put((Object)"minProcessingTime", (Object)mrb.getMinProcessingTime());
            jo.put((Object)"statistics", (Object)stats);
            return null;
        };
        this.doCall(options, task);
        root.put((Object)"routes", list);
        return root;
    }

    protected void doCall(Map<String, Object> options, Function<ManagedRouteMBean, Object> task) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getExtension(ManagedCamelContext.class);
        if (mcc != null) {
            List routes = this.getCamelContext().getRoutes();
            routes.sort((o1, o2) -> o1.getRouteId().compareToIgnoreCase(o2.getRouteId()));
            routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(r -> RouteDevConsole.accept(r, filter)).filter(r -> RouteDevConsole.accept(r, subPath)).sorted(RouteDevConsole::sort).limit(max).forEach(task::apply);
        }
    }

    private static boolean accept(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern((String)mrb.getRouteId(), (String)filter) || PatternHelper.matchPattern((String)mrb.getEndpointUri(), (String)filter) || PatternHelper.matchPattern((String)mrb.getSourceLocationShort(), (String)filter);
    }

    private static int sort(ManagedRouteMBean o1, ManagedRouteMBean o2) {
        return o1.getRouteId().compareTo(o2.getRouteId());
    }
}

