/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.apache.camel.component.couchdb.CouchDbException;
import org.apache.camel.impl.DefaultProducer;
import org.lightcouch.Response;

public class CouchDbProducer
extends DefaultProducer {
    private final CouchDbClientWrapper couchClient;

    public CouchDbProducer(CouchDbEndpoint endpoint, CouchDbClientWrapper couchClient) {
        super((Endpoint)endpoint);
        this.couchClient = couchClient;
    }

    public void process(Exchange exchange) throws Exception {
        JsonElement json = this.getBodyAsJsonElement(exchange);
        Response save = this.saveJsonElement(json);
        if (save == null) {
            throw new CouchDbException("Could not save document [unknown reason]", exchange);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Document saved [_id={}, _rev={}]", (Object)save.getId(), (Object)save.getRev());
        }
        exchange.getIn().setHeader("CouchDbRev", (Object)save.getRev());
        exchange.getIn().setHeader("CouchDbId", (Object)save.getId());
    }

    JsonElement getBodyAsJsonElement(Exchange exchange) throws InvalidPayloadException {
        Object body = exchange.getIn().getMandatoryBody();
        if (body instanceof String) {
            try {
                return new JsonParser().parse((String)body);
            }
            catch (JsonSyntaxException jse) {
                throw new InvalidPayloadException(exchange, body.getClass());
            }
        }
        if (body instanceof JsonElement) {
            return (JsonElement)body;
        }
        throw new InvalidPayloadException(exchange, body != null ? body.getClass() : null);
    }

    private Response saveJsonElement(JsonElement json) {
        JsonObject obj;
        Response save = json instanceof JsonObject ? ((obj = (JsonObject)json).get("_rev") == null ? this.couchClient.save(json) : this.couchClient.update(json)) : this.couchClient.save(json);
        return save;
    }
}

