/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.apache.camel.component.couchdb.CouchDbException;
import org.apache.camel.component.couchdb.CouchDbOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.lightcouch.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CouchDbProducer.class);
    private final CouchDbClientWrapper couchClient;

    public CouchDbProducer(CouchDbEndpoint endpoint, CouchDbClientWrapper couchClient) {
        super((Endpoint)endpoint);
        this.couchClient = couchClient;
    }

    public void process(Exchange exchange) throws Exception {
        JsonElement json = this.getBodyAsJsonElement(exchange);
        String operation = (String)exchange.getIn().getHeader("CouchDbMethod", String.class);
        if (ObjectHelper.isEmpty((String)operation)) {
            Response save = this.saveJsonElement(json);
            if (save == null) {
                throw new CouchDbException("Could not save document [unknown reason]", exchange);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Document saved [_id={}, _rev={}]", (Object)save.getId(), (Object)save.getRev());
            }
            exchange.getIn().setHeader("CouchDbRev", (Object)save.getRev());
            exchange.getIn().setHeader("CouchDbId", (Object)save.getId());
        } else {
            if (operation.equalsIgnoreCase(CouchDbOperations.DELETE.toString())) {
                Response delete = this.deleteJsonElement(json);
                if (delete == null) {
                    throw new CouchDbException("Could not delete document [unknown reason]", exchange);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Document saved [_id={}, _rev={}]", (Object)delete.getId(), (Object)delete.getRev());
                }
                exchange.getIn().setHeader("CouchDbRev", (Object)delete.getRev());
                exchange.getIn().setHeader("CouchDbId", (Object)delete.getId());
            }
            if (operation.equalsIgnoreCase(CouchDbOperations.GET.toString())) {
                String docId = (String)exchange.getIn().getHeader("CouchDbId", String.class);
                if (docId == null) {
                    throw new CouchDbException("Could not get document, document id is missing", exchange);
                }
                Object response = this.getElement(docId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Document retrieved [_id={}]", (Object)docId);
                }
                exchange.getIn().setBody(response);
            }
        }
    }

    JsonElement getBodyAsJsonElement(Exchange exchange) throws InvalidPayloadException {
        Object body = exchange.getIn().getMandatoryBody();
        if (body instanceof String) {
            try {
                return new JsonParser().parse((String)body);
            }
            catch (JsonSyntaxException jse) {
                throw new InvalidPayloadException(exchange, body.getClass());
            }
        }
        if (body instanceof JsonElement) {
            return (JsonElement)body;
        }
        throw new InvalidPayloadException(exchange, body != null ? body.getClass() : null);
    }

    private Response saveJsonElement(JsonElement json) {
        JsonObject obj;
        Response save = json instanceof JsonObject ? ((obj = (JsonObject)json).get("_rev") == null ? this.couchClient.save(json) : this.couchClient.update(json)) : this.couchClient.save(json);
        return save;
    }

    private Response deleteJsonElement(JsonElement json) {
        Response delete;
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            delete = this.couchClient.remove(obj);
        } else {
            delete = this.couchClient.remove(json);
        }
        return delete;
    }

    private Object getElement(String id) {
        Object response = this.couchClient.get(id);
        return response;
    }
}

