/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common.header;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.helpers.CastUtils;

public final class CxfHeaderHelper {
    private CxfHeaderHelper() {
    }

    public static void propagateCamelToCxf(HeaderFilterStrategy strategy, Map<String, Object> headers, org.apache.cxf.message.Message message, Exchange exchange) {
        TreeMap<String, List> cxfHeaders = CastUtils.cast((Map)((Map)message.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        if (cxfHeaders == null) {
            cxfHeaders = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
            message.put((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, cxfHeaders);
        }
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (strategy == null || strategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange)) continue;
            if ("Content-Type".equals(entry.getKey())) {
                message.put((Object)"Content-Type", entry.getValue());
            }
            if ("RequestContext".equals(entry.getKey()) || "ResponseContext".equals(entry.getKey())) {
                message.put((Object)entry.getKey(), entry.getValue());
                continue;
            }
            if ("CamelHttpResponseCode".equals(entry.getKey())) {
                message.put((Object)org.apache.cxf.message.Message.RESPONSE_CODE, entry.getValue());
                continue;
            }
            Object values = entry.getValue();
            if (values instanceof List) {
                cxfHeaders.put(entry.getKey(), CastUtils.cast((List)((List)values), String.class));
                continue;
            }
            ArrayList<String> listValue = new ArrayList<String>();
            listValue.add(entry.getValue().toString());
            cxfHeaders.put(entry.getKey(), listValue);
        }
    }

    public static void propagateCxfToCamel(HeaderFilterStrategy strategy, org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange exchange) {
        if (strategy == null) {
            return;
        }
        CxfHeaderHelper.copyHttpHeadersFromCxfToCamel(strategy, cxfMessage, camelMessage, exchange);
        Map cxfHeaders = CastUtils.cast((Map)((Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                if (strategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                List values = (List)entry.getValue();
                camelMessage.setHeader((String)entry.getKey(), CxfHeaderHelper.protocolHeaderValuesToSingleValue(values, exchange));
            }
        }
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, "RequestContext");
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, "ResponseContext");
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, org.apache.cxf.message.Message.RESPONSE_CODE, "CamelHttpResponseCode");
    }

    private static Object protocolHeaderValuesToSingleValue(List<String> values, Exchange exchange) {
        if (values.size() < 2) {
            return values.get(0);
        }
        if (!((Boolean)exchange.getProperty("CamelCxfProtocolHeadersMerged", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return values;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(',').append(' ');
        }
        return sb.toString();
    }

    public static void copyHttpHeadersFromCxfToCamel(HeaderFilterStrategy strategy, org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange exchange) {
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, "org.apache.cxf.request.uri", "CamelHttpUri");
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, "org.apache.cxf.request.method", "CamelHttpMethod");
        String pathInfo = (String)cxfMessage.get((Object)org.apache.cxf.message.Message.PATH_INFO);
        String basePath = (String)cxfMessage.get((Object)org.apache.cxf.message.Message.BASE_PATH);
        if (pathInfo != null && basePath != null && pathInfo.startsWith(basePath)) {
            pathInfo = pathInfo.substring(basePath.length());
        }
        if (pathInfo != null) {
            camelMessage.setHeader("CamelHttpPath", (Object)pathInfo);
        }
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, "Content-Type", "Content-Type");
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, org.apache.cxf.message.Message.ENCODING, "CamelHttpCharacterEncoding");
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, org.apache.cxf.message.Message.QUERY_STRING, "CamelHttpQuery");
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, "Accept", "CamelAcceptContentType");
    }

    private static void copyMessageHeader(HeaderFilterStrategy strategy, Exchange exchange, org.apache.cxf.message.Message cxfMessage, Message camelMessage, String key) {
        CxfHeaderHelper.copyMessageHeader(strategy, exchange, cxfMessage, camelMessage, key, key);
    }

    private static void copyMessageHeader(HeaderFilterStrategy strategy, Exchange exchange, org.apache.cxf.message.Message cxfMessage, Message camelMessage, String cxfKey, String camelKey) {
        Object value = cxfMessage.get((Object)cxfKey);
        if ("Content-Type".equals(cxfKey)) {
            value = CxfHeaderHelper.determineContentType(cxfMessage);
        }
        if (value != null && !strategy.applyFilterToExternalHeaders(cxfKey, value, exchange)) {
            camelMessage.setHeader(camelKey, value);
        }
    }

    private static String determineContentType(org.apache.cxf.message.Message message) {
        String ct = (String)message.get((Object)"Content-Type");
        String enc = (String)message.get((Object)org.apache.cxf.message.Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
                ct = ct + "; charset=" + enc;
            }
        } else {
            ct = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        message.put((Object)"Content-Type", (Object)ct);
        return ct;
    }
}

