/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.processor.remote;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.component.dns.DnsConfiguration;
import org.apache.camel.component.dns.processor.remote.DnsServiceCallServer;
import org.apache.camel.component.dns.processor.remote.DnsServiceCallServerListStrategy;
import org.apache.camel.component.dns.processor.remote.DnsServiceLookupFactory;
import org.apache.camel.spi.ServiceCallServer;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;

public final class DnsServiceCallServerListStrategies {
    private DnsServiceCallServerListStrategies() {
    }

    public static DnsServiceCallServerListStrategy onDemand(DnsConfiguration configuration) throws Exception {
        return new OnDemand(configuration);
    }

    public static final class OnDemand
    extends DnsServiceCallServerListStrategy {
        private final DnsServiceLookupFactory lookupFactory;

        public OnDemand(DnsConfiguration configuration) throws Exception {
            super(configuration);
            this.lookupFactory = new DnsServiceLookupFactory(configuration);
        }

        public List<ServiceCallServer> getUpdatedListOfServers(String name) {
            Lookup lookup = this.lookupFactory.apply(name);
            Record[] records = lookup.run();
            List<Object> servers = Objects.nonNull(records) && lookup.getResult() == 0 ? Arrays.stream(records).filter(SRVRecord.class::isInstance).map(SRVRecord.class::cast).sorted(DnsServiceCallServer.COMPARATOR).map(DnsServiceCallServer::new).collect(Collectors.toList()) : Collections.emptyList();
            return servers;
        }

        public String toString() {
            return "OnDemand";
        }
    }
}

