/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.modeline;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.dsl.modeline.DefaultModelineParser;
import org.apache.camel.dsl.modeline.ModelineParser;
import org.apache.camel.dsl.modeline.Trait;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;

@JdkService(value="dsl-modeline-factory")
public class DefaultModelineFactory
extends ServiceSupport
implements ModelineFactory,
CamelContextAware,
NonManagedService,
StaticService {
    private CamelContext camelContext;
    private ModelineParser parser;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void parseModeline(Resource resource) throws Exception {
        List<CamelContextCustomizer> customizers = this.parser.parse(resource);
        customizers.forEach(this::onConfigureModeline);
    }

    protected void onConfigureModeline(CamelContextCustomizer customizer) {
        customizer.configure(this.camelContext);
    }

    protected void doInit() throws Exception {
        PropertiesComponent pc;
        PropertiesSource ps;
        this.parser = (ModelineParser)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, ModelineParser.class);
        if (this.parser == null) {
            this.parser = this.createModelineParser();
        }
        if ((ps = (pc = this.camelContext.getPropertiesComponent()).getPropertiesSource("property")) instanceof Trait) {
            this.parser.addTrait((Trait)ps);
        }
    }

    protected ModelineParser createModelineParser() {
        return new DefaultModelineParser(this.camelContext);
    }

    public String toString() {
        return "camel-dsl-modeline";
    }
}

