/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.NormalizedUri;
import org.apache.camel.util.URISupport;

public class AbstractEndpointBuilder {
    protected final String scheme;
    protected final String path;
    protected final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    protected final Map<String, Map<String, Object>> multivalues = new HashMap<String, Map<String, Object>>();
    private volatile Endpoint resolvedEndpoint;
    private volatile Language simple;

    public AbstractEndpointBuilder(String scheme, String path) {
        this.scheme = scheme;
        this.path = path;
    }

    public Endpoint resolve(CamelContext context) throws NoSuchEndpointException {
        if (this.resolvedEndpoint != null) {
            return this.resolvedEndpoint;
        }
        AbstractEndpointBuilder.resolvePropertyPlaceholders(context, this.properties);
        LinkedHashMap<String, Object> remaining = new LinkedHashMap<String, Object>();
        NormalizedUri uri = this.computeUri(remaining, context, false, true);
        ExtendedCamelContext ecc = (ExtendedCamelContext)context;
        Endpoint endpoint = ecc.getEndpoint((NormalizedEndpointUri)uri, this.properties);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri.getUri());
        }
        this.resolvedEndpoint = endpoint;
        return endpoint;
    }

    private static void resolvePropertyPlaceholders(CamelContext context, Map<String, Object> properties) {
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            String text = (String)value;
            String changed = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).resolvePropertyPlaceholders(text, true);
            if (changed.startsWith("{{?")) {
                toRemove.add(entry.getKey());
                continue;
            }
            if (changed.equals(text)) continue;
            entry.setValue(changed);
        }
        if (!toRemove.isEmpty()) {
            for (String key : toRemove) {
                properties.remove(key);
            }
        }
    }

    public <T extends Endpoint> T resolve(CamelContext context, Class<T> endpointType) throws NoSuchEndpointException {
        Endpoint answer = this.resolve(context);
        return (T)((Endpoint)endpointType.cast(answer));
    }

    public String getUri() {
        return this.computeUri(new LinkedHashMap<String, Object>(), null, false, true).getUri();
    }

    protected NormalizedUri computeUri(Map<String, Object> remaining, CamelContext camelContext, boolean bindToRegistry, boolean encode) {
        NormalizedUri answer;
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        AbstractEndpointBuilder.computeProperties(remaining, camelContext, bindToRegistry, params, this.properties);
        for (Map<String, Object> map : this.multivalues.values()) {
            AbstractEndpointBuilder.computeProperties(remaining, camelContext, bindToRegistry, params, map);
        }
        if (!remaining.isEmpty()) {
            params.put("hash", Integer.toHexString(remaining.hashCode()));
        }
        String targetScheme = this.scheme;
        String targetPath = this.path;
        if (camelContext != null) {
            targetScheme = camelContext.resolvePropertyPlaceholders(targetScheme);
            targetPath = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)camelContext, (String)targetPath);
        }
        if (params.isEmpty()) {
            answer = NormalizedUri.newNormalizedUri((String)(targetScheme + "://" + targetPath), (boolean)true);
        } else {
            try {
                String query = URISupport.createQueryString(params, (boolean)encode);
                answer = targetPath.contains("?") ? NormalizedUri.newNormalizedUri((String)(targetScheme + "://" + targetPath + "&" + query), (boolean)true) : NormalizedUri.newNormalizedUri((String)(targetScheme + "://" + targetPath + "?" + query), (boolean)true);
            }
            catch (URISyntaxException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return answer;
    }

    private static void computeProperties(Map<String, Object> remaining, CamelContext camelContext, boolean bindToRegistry, Map<String, Object> params, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof String) {
                params.put(key, val);
                continue;
            }
            if (val instanceof Number || val instanceof Boolean || val instanceof Enum) {
                params.put(key, val.toString());
                continue;
            }
            if (camelContext != null && bindToRegistry) {
                String hash = Integer.toHexString(val.hashCode());
                params.put(key, "#" + hash);
                camelContext.getRegistry().bind(hash, val);
                continue;
            }
            remaining.put(key, val);
        }
    }

    public String toString() {
        return this.getUri();
    }

    public void doSetProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void doSetMultiValueProperty(String name, String key, Object value) {
        Map map = this.multivalues.computeIfAbsent(name, k -> new LinkedHashMap());
        map.put(key, value);
    }

    public void doSetMultiValueProperties(String name, String prefix, Map<String, Object> values) {
        values.forEach((k, v) -> this.doSetMultiValueProperty(name, prefix + k, v));
    }

    public Expression expr(CamelContext camelContext) {
        NormalizedUri uri = this.computeUri(new LinkedHashMap<String, Object>(), camelContext, true, false);
        if (this.simple == null) {
            this.simple = camelContext.resolveLanguage("simple");
        }
        return this.simple.createExpression(uri.getUri());
    }
}

