/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.credential.TokenCredential;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Map;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.azure.eventhubs.CredentialType;
import org.apache.camel.spi.ExceptionHandler;

public interface EventHubsEndpointBuilderFactory {
    public static EventHubsEndpointBuilder endpointBuilder(String componentName, String path) {
        class EventHubsEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements EventHubsEndpointBuilder,
        AdvancedEventHubsEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public EventHubsEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new EventHubsEndpointBuilderImpl(path, componentName);
    }

    public static class EventHubsHeaderNameBuilder {
        private static final EventHubsHeaderNameBuilder INSTANCE = new EventHubsHeaderNameBuilder();

        public String azureEventHubsPartitionKey() {
            return "CamelAzureEventHubsPartitionKey";
        }

        public String azureEventHubsPartitionId() {
            return "CamelAzureEventHubsPartitionId";
        }

        public String azureEventHubsOffset() {
            return "CamelAzureEventHubsOffset";
        }

        public String azureEventHubsEnqueuedTime() {
            return "CamelAzureEventHubsEnqueuedTime";
        }

        public String azureEventHubsSequenceNumber() {
            return "CamelAzureEventHubsSequenceNumber";
        }

        public String azureEventHubsMetadata() {
            return "CamelAzureEventHubsMetadata";
        }

        public String messageTimestamp() {
            return "CamelMessageTimestamp";
        }

        public String azureEventHubsCheckpointUpdatedBy() {
            return "CamelAzureEventHubsCheckpointUpdatedBy";
        }
    }

    public static interface EventHubsBuilders {
        default public EventHubsHeaderNameBuilder azureEventhubs() {
            return EventHubsHeaderNameBuilder.INSTANCE;
        }

        default public EventHubsEndpointBuilder azureEventhubs(String path) {
            return EventHubsEndpointBuilderFactory.endpointBuilder("azure-eventhubs", path);
        }

        default public EventHubsEndpointBuilder azureEventhubs(String componentName, String path) {
            return EventHubsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedEventHubsEndpointBuilder
    extends AdvancedEventHubsEndpointConsumerBuilder,
    AdvancedEventHubsEndpointProducerBuilder {
        @Override
        default public EventHubsEndpointBuilder basic() {
            return (EventHubsEndpointBuilder)((Object)this);
        }
    }

    public static interface EventHubsEndpointBuilder
    extends EventHubsEndpointConsumerBuilder,
    EventHubsEndpointProducerBuilder {
        @Override
        default public AdvancedEventHubsEndpointBuilder advanced() {
            return (AdvancedEventHubsEndpointBuilder)((Object)this);
        }

        @Override
        default public EventHubsEndpointBuilder amqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder amqpRetryOptions(String amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder amqpTransportType(AmqpTransportType amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder amqpTransportType(String amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder connectionString(String connectionString) {
            this.doSetProperty("connectionString", connectionString);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder sharedAccessKey(String sharedAccessKey) {
            this.doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder sharedAccessName(String sharedAccessName) {
            this.doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder tokenCredential(TokenCredential tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }

        @Override
        default public EventHubsEndpointBuilder tokenCredential(String tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    public static interface AdvancedEventHubsEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public EventHubsEndpointProducerBuilder basic() {
            return (EventHubsEndpointProducerBuilder)((Object)this);
        }

        default public AdvancedEventHubsEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedEventHubsEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface EventHubsEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedEventHubsEndpointProducerBuilder advanced() {
            return (AdvancedEventHubsEndpointProducerBuilder)((Object)this);
        }

        default public EventHubsEndpointProducerBuilder amqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public EventHubsEndpointProducerBuilder amqpRetryOptions(String amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public EventHubsEndpointProducerBuilder amqpTransportType(AmqpTransportType amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public EventHubsEndpointProducerBuilder amqpTransportType(String amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public EventHubsEndpointProducerBuilder partitionId(String partitionId) {
            this.doSetProperty("partitionId", partitionId);
            return this;
        }

        default public EventHubsEndpointProducerBuilder partitionKey(String partitionKey) {
            this.doSetProperty("partitionKey", partitionKey);
            return this;
        }

        default public EventHubsEndpointProducerBuilder producerAsyncClient(EventHubProducerAsyncClient producerAsyncClient) {
            this.doSetProperty("producerAsyncClient", producerAsyncClient);
            return this;
        }

        default public EventHubsEndpointProducerBuilder producerAsyncClient(String producerAsyncClient) {
            this.doSetProperty("producerAsyncClient", producerAsyncClient);
            return this;
        }

        default public EventHubsEndpointProducerBuilder connectionString(String connectionString) {
            this.doSetProperty("connectionString", connectionString);
            return this;
        }

        default public EventHubsEndpointProducerBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public EventHubsEndpointProducerBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public EventHubsEndpointProducerBuilder sharedAccessKey(String sharedAccessKey) {
            this.doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }

        default public EventHubsEndpointProducerBuilder sharedAccessName(String sharedAccessName) {
            this.doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }

        default public EventHubsEndpointProducerBuilder tokenCredential(TokenCredential tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }

        default public EventHubsEndpointProducerBuilder tokenCredential(String tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    public static interface AdvancedEventHubsEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public EventHubsEndpointConsumerBuilder basic() {
            return (EventHubsEndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedEventHubsEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedEventHubsEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedEventHubsEndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedEventHubsEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedEventHubsEndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedEventHubsEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public static interface EventHubsEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedEventHubsEndpointConsumerBuilder advanced() {
            return (AdvancedEventHubsEndpointConsumerBuilder)((Object)this);
        }

        default public EventHubsEndpointConsumerBuilder amqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder amqpRetryOptions(String amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder amqpTransportType(AmqpTransportType amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder amqpTransportType(String amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder blobAccessKey(String blobAccessKey) {
            this.doSetProperty("blobAccessKey", blobAccessKey);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder blobAccountName(String blobAccountName) {
            this.doSetProperty("blobAccountName", blobAccountName);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder blobContainerName(String blobContainerName) {
            this.doSetProperty("blobContainerName", blobContainerName);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder blobStorageSharedKeyCredential(StorageSharedKeyCredential blobStorageSharedKeyCredential) {
            this.doSetProperty("blobStorageSharedKeyCredential", blobStorageSharedKeyCredential);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder blobStorageSharedKeyCredential(String blobStorageSharedKeyCredential) {
            this.doSetProperty("blobStorageSharedKeyCredential", blobStorageSharedKeyCredential);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder checkpointBatchSize(int checkpointBatchSize) {
            this.doSetProperty("checkpointBatchSize", checkpointBatchSize);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder checkpointBatchSize(String checkpointBatchSize) {
            this.doSetProperty("checkpointBatchSize", checkpointBatchSize);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder checkpointBatchTimeout(int checkpointBatchTimeout) {
            this.doSetProperty("checkpointBatchTimeout", checkpointBatchTimeout);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder checkpointBatchTimeout(String checkpointBatchTimeout) {
            this.doSetProperty("checkpointBatchTimeout", checkpointBatchTimeout);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder checkpointStore(CheckpointStore checkpointStore) {
            this.doSetProperty("checkpointStore", checkpointStore);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder checkpointStore(String checkpointStore) {
            this.doSetProperty("checkpointStore", checkpointStore);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder consumerGroupName(String consumerGroupName) {
            this.doSetProperty("consumerGroupName", consumerGroupName);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder eventPosition(Map<String, EventPosition> eventPosition) {
            this.doSetProperty("eventPosition", eventPosition);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder eventPosition(String eventPosition) {
            this.doSetProperty("eventPosition", eventPosition);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder prefetchCount(int prefetchCount) {
            this.doSetProperty("prefetchCount", prefetchCount);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder prefetchCount(String prefetchCount) {
            this.doSetProperty("prefetchCount", prefetchCount);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder connectionString(String connectionString) {
            this.doSetProperty("connectionString", connectionString);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder sharedAccessKey(String sharedAccessKey) {
            this.doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder sharedAccessName(String sharedAccessName) {
            this.doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder tokenCredential(TokenCredential tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }

        default public EventHubsEndpointConsumerBuilder tokenCredential(String tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }
}

