/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar;

import com.google.api.services.calendar.Calendar;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.calendar.BatchGoogleCalendarClientFactory;
import org.apache.camel.component.google.calendar.GoogleCalendarClientFactory;
import org.apache.camel.component.google.calendar.GoogleCalendarConfiguration;
import org.apache.camel.component.google.calendar.GoogleCalendarEndpoint;
import org.apache.camel.component.google.calendar.internal.GoogleCalendarApiCollection;
import org.apache.camel.component.google.calendar.internal.GoogleCalendarApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;

@Component(value="google-calendar")
public class GoogleCalendarComponent
extends AbstractApiComponent<GoogleCalendarApiName, GoogleCalendarConfiguration, GoogleCalendarApiCollection> {
    @Metadata
    GoogleCalendarConfiguration configuration;
    @Metadata(label="advanced")
    private Calendar client;
    @Metadata(label="advanced")
    private GoogleCalendarClientFactory clientFactory;

    public GoogleCalendarComponent() {
        super(GoogleCalendarEndpoint.class, GoogleCalendarApiName.class, (ApiCollection)GoogleCalendarApiCollection.getCollection());
    }

    public GoogleCalendarComponent(CamelContext context) {
        super(context, GoogleCalendarEndpoint.class, GoogleCalendarApiName.class, (ApiCollection)GoogleCalendarApiCollection.getCollection());
    }

    protected GoogleCalendarApiName getApiName(String apiNameStr) {
        return (GoogleCalendarApiName)((Object)this.getCamelContext().getTypeConverter().convertTo(GoogleCalendarApiName.class, (Object)apiNameStr));
    }

    public Calendar getClient(GoogleCalendarConfiguration config) {
        if (this.client == null) {
            if (config.getClientId() != null && !config.getClientId().isBlank() && config.getClientSecret() != null && !config.getClientSecret().isBlank()) {
                this.client = this.getClientFactory().makeClient(config.getClientId(), config.getClientSecret(), config.getScopes(), config.getApplicationName(), config.getRefreshToken(), config.getAccessToken(), config.getEmailAddress(), config.getP12FileName(), config.getUser());
            } else if (config.getServiceAccountKey() != null && !config.getServiceAccountKey().isBlank()) {
                this.client = this.getClientFactory().makeClient(this.getCamelContext(), config.getServiceAccountKey(), config.getScopes(), config.getApplicationName(), config.getDelegate());
            } else {
                throw new IllegalArgumentException("(clientId and clientSecret) or serviceAccountKey are required to create Google Calendar client");
            }
        }
        return this.client;
    }

    public GoogleCalendarClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleCalendarClientFactory();
        }
        return this.clientFactory;
    }

    public GoogleCalendarConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GoogleCalendarConfiguration();
        }
        return (GoogleCalendarConfiguration)super.getConfiguration();
    }

    public void setConfiguration(GoogleCalendarConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public void setClientFactory(GoogleCalendarClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String methodName, GoogleCalendarApiName apiName, GoogleCalendarConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new GoogleCalendarEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }
}

