/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail;

import com.google.api.services.gmail.Gmail;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.component.google.mail.GoogleMailComponent;
import org.apache.camel.component.google.mail.GoogleMailConfiguration;
import org.apache.camel.component.google.mail.GoogleMailConsumer;
import org.apache.camel.component.google.mail.GoogleMailProducer;
import org.apache.camel.component.google.mail.internal.GoogleMailApiCollection;
import org.apache.camel.component.google.mail.internal.GoogleMailApiName;
import org.apache.camel.component.google.mail.internal.GoogleMailPropertiesHelper;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.15.0", scheme="google-mail", title="Google Mail", syntax="google-mail:apiName/methodName", apiSyntax="apiName/methodName", consumerPrefix="consumer", category={Category.CLOUD, Category.API, Category.MAIL})
public class GoogleMailEndpoint
extends AbstractApiEndpoint<GoogleMailApiName, GoogleMailConfiguration>
implements EndpointServiceLocation {
    private Object apiProxy;
    @UriParam
    private GoogleMailConfiguration configuration;

    public GoogleMailEndpoint(String uri, GoogleMailComponent component, GoogleMailApiName apiName, String methodName, GoogleMailConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, GoogleMailApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new GoogleMailProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        GoogleMailConsumer consumer = new GoogleMailConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<GoogleMailConfiguration> getPropertiesHelper() {
        return GoogleMailPropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelGoogleMail";
    }

    protected void afterConfigureProperties() {
        switch ((GoogleMailApiName)this.apiName) {
            case ATTACHMENTS: {
                this.apiProxy = this.getClient().users().messages().attachments();
                break;
            }
            case DRAFTS: {
                this.apiProxy = this.getClient().users().drafts();
                break;
            }
            case HISTORY: {
                this.apiProxy = this.getClient().users().history();
                break;
            }
            case LABELS: {
                this.apiProxy = this.getClient().users().labels();
                break;
            }
            case MESSAGES: {
                this.apiProxy = this.getClient().users().messages();
                break;
            }
            case THREADS: {
                this.apiProxy = this.getClient().users().threads();
                break;
            }
            case USERS: {
                this.apiProxy = this.getClient().users();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + String.valueOf(this.apiName));
            }
        }
    }

    public Gmail getClient() {
        return ((GoogleMailComponent)this.getComponent()).getClient(this.configuration);
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }

    public GoogleMailClientFactory getClientFactory() {
        return ((GoogleMailComponent)this.getComponent()).getClientFactory();
    }

    public void setClientFactory(GoogleMailClientFactory clientFactory) {
        ((GoogleMailComponent)this.getComponent()).setClientFactory(clientFactory);
    }

    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty((Object)(ObjectHelper.isNotEmpty((Object)((Object)this.configuration.getApiName())) && ObjectHelper.isNotEmpty((String)this.configuration.getMethodName()) ? 1 : 0))) {
            return this.getServiceProtocol() + ":" + String.valueOf((Object)this.configuration.getApiName()) + ":" + this.configuration.getMethodName();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "mail";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getApplicationName() != null) {
            return Map.of("applicationName", this.configuration.getApplicationName());
        }
        return null;
    }
}

