/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="google-sheets-stream:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Google Sheets Stream consumer response details")
public class GoogleSheetsStreamCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.google.sheets.stream.consume");
        if (message.getHeaders().containsKey("CamelGoogleSheetsSpreadsheetId")) {
            headers.put("CamelCloudEventSource", "google.sheets.stream." + (String)message.getHeader("CamelGoogleSheetsSpreadsheetId", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelGoogleSheetsSpreadsheetUrl"));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

