/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.filters;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.hbase.filters.ModelAwareFilter;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;

public class ModelAwareFilterList
extends FilterList
implements ModelAwareFilter<FilterList> {
    public ModelAwareFilterList() {
    }

    public ModelAwareFilterList(List<Filter> rowFilters) {
        super(rowFilters);
    }

    public ModelAwareFilterList(FilterList.Operator operator) {
        super(operator);
    }

    public ModelAwareFilterList(FilterList.Operator operator, List<Filter> rowFilters) {
        super(operator, rowFilters);
    }

    @Override
    public void apply(CamelContext context, HBaseRow rowModel) {
        for (Filter filter : this.getFilters()) {
            if (!ModelAwareFilter.class.isAssignableFrom(filter.getClass())) continue;
            ((ModelAwareFilter)filter).apply(context, rowModel);
        }
    }

    public ModelAwareFilterList wrap(FilterList filter) {
        return new ModelAwareFilterList(filter.getOperator(), filter.getFilters());
    }
}

