/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHealthCheck
implements HealthCheck,
CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHealthCheck.class);
    private CamelContext camelContext;
    private final Object lock = new Object();
    private final String group;
    private final String id;
    private final ConcurrentMap<String, Object> meta;
    private HealthCheckConfiguration configuration;
    private HealthCheck.Result lastResult;
    private ZonedDateTime lastInvocation;

    protected AbstractHealthCheck(String id) {
        this(null, id, null);
    }

    protected AbstractHealthCheck(String group, String id) {
        this(group, id, null);
    }

    protected AbstractHealthCheck(String group, String id, Map<String, Object> meta) {
        this.group = group;
        this.id = (String)ObjectHelper.notNull((Object)id, (String)"HealthCheck ID");
        this.configuration = new HealthCheckConfiguration();
        this.meta = new ConcurrentHashMap<String, Object>();
        if (meta != null) {
            this.meta.putAll(meta);
        }
        this.meta.put("check.id", id);
        if (group != null) {
            this.meta.putIfAbsent("check.group", group);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.meta);
    }

    public HealthCheckConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HealthCheckConfiguration configuration) {
        this.configuration = configuration;
    }

    public HealthCheck.Result call() {
        return this.call(Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheck.Result call(Map<String, Object> options) {
        Object object = this.lock;
        synchronized (object) {
            Duration elapsed;
            HealthCheckConfiguration conf = this.getConfiguration();
            HealthCheckResultBuilder builder = HealthCheckResultBuilder.on((HealthCheck)this);
            ZonedDateTime now = ZonedDateTime.now();
            boolean enabled = conf.isEnabled();
            long interval = conf.getInterval();
            int failureThreshold = conf.getFailureThreshold();
            int successThreshold = conf.getSuccessThreshold();
            int invocationCount = (Integer)this.meta.getOrDefault("invocation.count", 0);
            int failureCount = (Integer)this.meta.getOrDefault("failure.count", 0);
            int successCount = (Integer)this.meta.getOrDefault("success.count", 0);
            String invocationTime = now.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
            boolean call = true;
            this.meta.put("invocation.attempt.time", invocationTime);
            if (!enabled) {
                LOGGER.debug("health-check {}/{} won't be invoked as not enabled", (Object)this.getGroup(), (Object)this.getId());
                builder.message("Disabled");
                builder.detail("check.enabled", (Object)false);
                return builder.unknown().build();
            }
            if (this.lastResult != null && this.lastInvocation != null && interval > 0L && (elapsed = Duration.between(this.lastInvocation, now)).compareTo(Duration.ofMillis(interval)) < 0) {
                LOGGER.debug("health-check {}/{} won't be invoked as interval ({}) is not yet expired (last-invocation={})", new Object[]{this.getGroup(), this.getId(), elapsed, this.lastInvocation});
                call = false;
            }
            if (call) {
                LOGGER.debug("Invoke health-check {}/{}", (Object)this.getGroup(), (Object)this.getId());
                this.doCall(builder, options);
                ObjectHelper.notNull((Object)builder.state(), (String)"Response State");
                if (builder.state() == HealthCheck.State.DOWN) {
                    successCount = 0;
                    if (failureCount++ < failureThreshold) {
                        LOGGER.debug("Health-check {}/{} has status DOWN but failure count ({}) is less than configured threshold ({})", new Object[]{this.getGroup(), this.getId(), failureCount, failureThreshold});
                        builder.up();
                    }
                } else if (builder.state() == HealthCheck.State.UP) {
                    failureCount = 0;
                    if (successCount++ < successThreshold) {
                        LOGGER.debug("Health-check {}/{} has status UP but success count ({}) is less than configured threshold ({})", new Object[]{this.getGroup(), this.getId(), successCount, successThreshold});
                        builder.down();
                    }
                }
                this.meta.put("invocation.time", invocationTime);
                this.meta.put("invocation.count", ++invocationCount);
                this.meta.put("failure.count", failureCount);
                this.meta.put("success.count", successCount);
                builder.detail("invocation.time", this.meta.get("invocation.time"));
                builder.detail("invocation.count", this.meta.get("invocation.count"));
                builder.detail("failure.count", this.meta.get("failure.count"));
                builder.detail("success.count", this.meta.get("success.count"));
                this.lastInvocation = now;
            } else if (this.lastResult != null) {
                this.lastResult.getMessage().ifPresent(arg_0 -> ((HealthCheckResultBuilder)builder).message(arg_0));
                this.lastResult.getError().ifPresent(arg_0 -> ((HealthCheckResultBuilder)builder).error(arg_0));
                builder.state(this.lastResult.getState());
                builder.details(this.lastResult.getDetails());
            }
            this.lastResult = builder.build();
            return this.lastResult;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractHealthCheck)) {
            return false;
        }
        AbstractHealthCheck that = (AbstractHealthCheck)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    protected final void addMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    protected abstract void doCall(HealthCheckResultBuilder var1, Map<String, Object> var2);
}

