/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.hessian;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;

public class HessianDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final String FORMAT_NAME = "hessian";

    public String getDataFormatName() {
        return FORMAT_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        Hessian2Output out = new Hessian2Output(outputStream);
        try {
            out.startMessage();
            out.writeObject(graph);
            out.completeMessage();
        }
        finally {
            out.flush();
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Hessian2Input in = new Hessian2Input(inputStream);
        try {
            in.startMessage();
            Object obj = in.readObject();
            in.completeMessage();
            Object object = obj;
            return object;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

