/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.http.HttpDeleteWithBodyMethod;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpEntityConverter;
import org.apache.camel.component.http.HttpGetWithBodyMethod;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.helper.HttpMethodHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.http.common.HttpProtocolHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GZIPHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.URISupport;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProducer.class);
    private HttpClient httpClient;
    private HttpContext httpContext;
    private boolean throwException;
    private boolean transferException;
    private HeaderFilterStrategy httpProtocolHeaderFilterStrategy = new HttpProtocolHeaderFilterStrategy();

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.getHttpClient();
        this.httpContext = endpoint.getHttpContext();
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.transferException = endpoint.isTransferException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        HttpResponse response;
        String hostHeader;
        String key;
        if (this.getEndpoint().isClearExpiredCookies() && !this.getEndpoint().isBridgeEndpoint()) {
            this.getEndpoint().getCookieStore().clearExpired(new Date());
        }
        Map skipRequestHeaders = null;
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery((String)queryString, (boolean)false, (boolean)true);
            }
        }
        HttpRequestBase httpRequest = this.createMethod(exchange);
        Message in = exchange.getIn();
        String httpProtocolVersion = (String)in.getHeader("CamelHttpProtocolVersion", String.class);
        if (httpProtocolVersion != null) {
            int[] version = HttpHelper.parserHttpVersion((String)httpProtocolVersion);
            httpRequest.setProtocolVersion((ProtocolVersion)new HttpVersion(version[0], version[1]));
        }
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        if (this.getEndpoint().getCustomHostHeader() != null) {
            httpRequest.setHeader("Host", this.getEndpoint().getCustomHostHeader());
        }
        if (strategy != null) {
            TypeConverter tc = exchange.getContext().getTypeConverter();
            for (Map.Entry entry : in.getHeaders().entrySet()) {
                String value;
                Object headerValue;
                key = (String)entry.getKey();
                if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key) || (headerValue = entry.getValue()) == null) continue;
                if (headerValue instanceof String) {
                    value = (String)headerValue;
                    if (strategy.applyFilterToCamelHeaders(key, (Object)value, exchange)) continue;
                    httpRequest.addHeader(key, value);
                    continue;
                }
                if (headerValue instanceof Long || headerValue instanceof Integer || headerValue instanceof Boolean) {
                    value = (String)tc.convertTo(String.class, exchange, headerValue);
                    if (strategy.applyFilterToCamelHeaders(key, (Object)value, exchange)) continue;
                    httpRequest.addHeader(key, value);
                    continue;
                }
                Iterator it = ObjectHelper.createIterator(headerValue, null, (boolean)true);
                ArrayList<String> multiValues = null;
                String prev = null;
                while (it.hasNext()) {
                    String value2 = (String)tc.convertTo(String.class, it.next());
                    if (value2 == null || strategy.applyFilterToCamelHeaders(key, (Object)value2, exchange)) continue;
                    if (prev == null) {
                        prev = value2;
                        continue;
                    }
                    if (multiValues == null) {
                        multiValues = new ArrayList<String>();
                        multiValues.add(prev);
                    }
                    multiValues.add(value2);
                }
                if (multiValues != null) {
                    String s = multiValues.size() > 1 ? ((Object)multiValues).toString() : (String)multiValues.get(0);
                    httpRequest.addHeader(key, s);
                    continue;
                }
                if (prev == null) continue;
                httpRequest.addHeader(key, prev);
            }
        }
        if (this.getEndpoint().getCookieHandler() != null) {
            Map cookieHeaders = this.getEndpoint().getCookieHandler().loadCookies(exchange, httpRequest.getURI());
            for (Map.Entry entry : cookieHeaders.entrySet()) {
                key = (String)entry.getKey();
                if (((List)entry.getValue()).isEmpty()) continue;
                httpRequest.addHeader(key, String.join((CharSequence)";", (Iterable)entry.getValue()));
            }
        }
        if (this.getEndpoint().isPreserveHostHeader() && (hostHeader = (String)exchange.getIn().getHeader("Host", String.class)) != null) {
            httpRequest.setHeader("Host", hostHeader);
        }
        if (this.getEndpoint().isConnectionClose()) {
            httpRequest.addHeader("Connection", "Close");
        }
        HttpResponse httpResponse = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing http {} method: {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getURI());
            }
            httpResponse = this.executeMethod((HttpUriRequest)httpRequest);
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            LOG.debug("Http responseCode: {}", (Object)responseCode);
            if (!this.throwException) {
                this.populateResponse(exchange, httpRequest, httpResponse, in, strategy, responseCode);
            } else {
                boolean ok = HttpHelper.isStatusCodeOk((int)responseCode, (String)this.getEndpoint().getOkStatusCodeRange());
                if (ok) {
                    this.populateResponse(exchange, httpRequest, httpResponse, in, strategy, responseCode);
                } else {
                    throw this.populateHttpOperationFailedException(exchange, httpRequest, httpResponse, responseCode);
                }
            }
            response = httpResponse;
        }
        catch (Throwable throwable) {
            HttpResponse response2 = httpResponse;
            if (httpResponse != null && this.getEndpoint().isDisableStreamCache()) {
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new SynchronizationAdapter(response2){
                    final /* synthetic */ HttpResponse val$response;
                    {
                        this.val$response = httpResponse;
                    }

                    public void onDone(Exchange exchange) {
                        try {
                            EntityUtils.consume((HttpEntity)this.val$response.getEntity());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            } else if (httpResponse != null) {
                try {
                    EntityUtils.consume((HttpEntity)response2.getEntity());
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (httpResponse != null && this.getEndpoint().isDisableStreamCache()) {
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new /* invalid duplicate definition of identical inner class */);
        } else if (httpResponse != null) {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable) {}
        }
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException, ClassNotFoundException {
        Object response = this.extractResponseBody(httpRequest, httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        Message answer = exchange.getOut();
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        if (httpResponse.getStatusLine() != null) {
            answer.setHeader("CamelHttpResponseText", (Object)httpResponse.getStatusLine().getReasonPhrase());
        }
        answer.setBody(response);
        HashMap<String, List> cookieHeaders = null;
        if (this.getEndpoint().getCookieHandler() != null) {
            cookieHeaders = new HashMap<String, List>();
        }
        Header[] headers = httpResponse.getAllHeaders();
        boolean found = false;
        for (Header header : headers) {
            String name = header.getName();
            String value = header.getValue();
            if (cookieHeaders != null) {
                cookieHeaders.computeIfAbsent(name, k -> new ArrayList()).add(value);
            }
            if (!found && name.equalsIgnoreCase("content-type")) {
                name = "Content-Type";
                exchange.setProperty("CamelCharsetName", (Object)IOHelper.getCharsetNameFromContentType((String)value));
                found = true;
            }
            Object extracted = HttpHelper.extractHttpParameterValue((String)value);
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
            HttpHelper.appendHeader((Map)answer.getHeaders(), (String)name, (Object)extracted);
        }
        if (this.getEndpoint().getCookieHandler() != null) {
            this.getEndpoint().getCookieHandler().storeCookies(exchange, httpRequest.getURI(), cookieHeaders);
        }
        if (this.getEndpoint().isCopyHeaders()) {
            MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)answer, (HeaderFilterStrategy)this.httpProtocolHeaderFilterStrategy, (boolean)false);
        }
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, int responseCode) throws IOException, ClassNotFoundException {
        Header locationHeader;
        String uri = httpRequest.getURI().toString();
        String statusText = httpResponse.getStatusLine() != null ? httpResponse.getStatusLine().getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(httpResponse.getAllHeaders());
        if (this.getEndpoint().getCookieHandler() != null) {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> e : headers.entrySet()) {
                m.put(e.getKey(), Collections.singletonList(e.getValue()));
            }
            this.getEndpoint().getCookieHandler().storeCookies(exchange, httpRequest.getURI(), m);
        }
        Object responseBody = this.extractResponseBody(httpRequest, httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        if (this.transferException && responseBody instanceof Exception) {
            return (Exception)responseBody;
        }
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        HttpOperationFailedException answer = (locationHeader = httpResponse.getFirstHeader("location")) != null && responseCode >= 300 && responseCode < 400 ? new HttpOperationFailedException(uri, responseCode, statusText, locationHeader.getValue(), headers, copy) : new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        return answer;
    }

    protected HttpResponse executeMethod(HttpUriRequest httpRequest) throws IOException {
        BasicHttpContext localContext = new BasicHttpContext();
        if (this.getEndpoint().isAuthenticationPreemptive()) {
            BasicScheme basicAuth = new BasicScheme();
            localContext.setAttribute("preemptive-auth", (Object)basicAuth);
        }
        if (this.httpContext != null) {
            localContext = new BasicHttpContext(this.httpContext);
        }
        return this.httpClient.execute(httpRequest, (HttpContext)localContext);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return null;
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected Object extractResponseBody(HttpRequestBase httpRequest, HttpResponse httpResponse, Exchange exchange, boolean ignoreResponseBody) throws IOException, ClassNotFoundException {
        String contentEncoding;
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        if (is == null) {
            return null;
        }
        Header header = httpResponse.getFirstHeader("Content-Encoding");
        String string = contentEncoding = header != null ? header.getValue() : null;
        if (!((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            is = GZIPHelper.uncompressGzip((String)contentEncoding, (InputStream)is);
        }
        String contentType = null;
        header = httpResponse.getFirstHeader("content-type");
        if (header != null) {
            contentType = header.getValue();
            HttpHelper.setCharsetFromContentType((String)contentType, (Exchange)exchange);
        }
        if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
            if (this.getEndpoint().getComponent().isAllowJavaSerializedObject() || this.getEndpoint().isTransferException()) {
                return HttpHelper.deserializeJavaObjectFromStream((InputStream)is, (CamelContext)exchange.getContext());
            }
            return null;
        }
        if (!this.getEndpoint().isDisableStreamCache()) {
            InputStream response = null;
            if (!ignoreResponseBody) {
                response = this.doExtractResponseBodyAsStream(is, exchange);
            }
            return response;
        }
        return is;
    }

    private InputStream doExtractResponseBodyAsStream(InputStream is, Exchange exchange) throws IOException {
        CachedOutputStream cos = null;
        try {
            cos = new CachedOutputStream(exchange, false);
            IOHelper.copy((InputStream)is, (OutputStream)cos);
            InputStream inputStream = cos.getWrappedInputStream();
            return inputStream;
        }
        catch (IOException ex) {
            try {
                cos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"Extracting response body", (Logger)LOG);
        }
    }

    protected HttpRequestBase createMethod(Exchange exchange) throws Exception {
        HttpEntity requestEntity;
        String url = HttpHelper.createURL((Exchange)exchange, (HttpCommonEndpoint)this.getEndpoint());
        URI uri = HttpHelper.createURI((Exchange)exchange, (String)url, (HttpCommonEndpoint)this.getEndpoint());
        url = uri.toASCIIString();
        HttpMethods methodToUse = HttpMethodHelper.createMethod(exchange, this.getEndpoint());
        Object method = methodToUse.createMethod(url);
        if (this.getEndpoint().isDeleteWithBody() && "DELETE".equals(method.getMethod())) {
            requestEntity = this.createRequestEntity(exchange);
            method = new HttpDeleteWithBodyMethod(url, requestEntity);
        } else if (this.getEndpoint().isGetWithBody() && "GET".equals(method.getMethod())) {
            requestEntity = this.createRequestEntity(exchange);
            method = new HttpGetWithBodyMethod(url, requestEntity);
        }
        LOG.trace("Using URL: {} with method: {}", (Object)url, method);
        if (methodToUse.isEntityEnclosing()) {
            requestEntity = this.createRequestEntity(exchange);
            ((HttpEntityEnclosingRequestBase)method).setEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null) {
                LOG.debug("No Content-Type provided for URL: {} with exchange: {}", (Object)url, (Object)exchange);
            }
        }
        if (method.getURI().getScheme() == null || method.getURI().getHost() == null) {
            throw new IllegalArgumentException("Invalid uri: " + uri + ". If you are forwarding/bridging http endpoints, then enable the bridgeEndpoint option on the endpoint: " + (Object)((Object)this.getEndpoint()));
        }
        return method;
    }

    protected HttpEntity createRequestEntity(Exchange exchange) throws CamelExchangeException {
        HttpEntity answer = null;
        Message in = exchange.getIn();
        Object body = in.getBody();
        try {
            if (body == null) {
                return null;
            }
            if (body instanceof HttpEntity) {
                answer = (HttpEntity)body;
            } else if (body instanceof byte[]) {
                answer = HttpEntityConverter.toHttpEntity((byte[])body, exchange);
            } else if (body instanceof InputStream) {
                answer = HttpEntityConverter.toHttpEntity((InputStream)body, exchange);
            } else if (body instanceof String) {
                answer = HttpEntityConverter.toHttpEntity((String)body, exchange);
            }
        }
        catch (Exception e) {
            throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, (Throwable)e);
        }
        if (answer == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    StringEntity entity;
                    String contentTypeString = ExchangeHelper.getContentType((Exchange)exchange);
                    ContentType contentType = null;
                    if (contentTypeString != null) {
                        contentType = contentTypeString.indexOf("charset") > 0 || contentTypeString.indexOf(59) > 0 ? ContentType.parse((String)contentTypeString) : ContentType.create((String)contentTypeString);
                    }
                    if (contentTypeString != null && "application/x-java-serialized-object".equals(contentTypeString)) {
                        if (!this.getEndpoint().getComponent().isAllowJavaSerializedObject()) {
                            throw new CamelExchangeException("Content-type application/x-java-serialized-object is not allowed", exchange);
                        }
                        Serializable obj = (Serializable)in.getMandatoryBody(Serializable.class);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        HttpHelper.writeObjectToStream((OutputStream)bos, (Object)obj);
                        ByteArrayEntity entity2 = new ByteArrayEntity(bos.toByteArray());
                        entity2.setContentType("application/x-java-serialized-object");
                        IOHelper.close((Closeable)bos);
                        answer = entity2;
                    } else if (data instanceof File || data instanceof GenericFile) {
                        File file = (File)in.getBody(File.class);
                        if (file != null) {
                            answer = contentType != null ? new FileEntity(file, contentType) : new FileEntity(file);
                        }
                    } else if (data instanceof String) {
                        Charset cs;
                        String charset = ExchangeHelper.getCharsetName((Exchange)exchange, (boolean)false);
                        if (charset == null && contentType != null && (cs = contentType.getCharset()) != null) {
                            charset = cs.name();
                        }
                        entity = new StringEntity((String)data, charset);
                        entity.setContentType(contentType != null ? contentType.toString() : null);
                        answer = entity;
                    }
                    if (answer == null) {
                        InputStream is = (InputStream)in.getMandatoryBody(InputStream.class);
                        entity = new InputStreamEntity(is, -1L);
                        if (contentType != null) {
                            entity.setContentType(contentType.toString());
                        }
                        answer = entity;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, (Throwable)e);
            }
            catch (IOException e) {
                throw new CamelExchangeException("Error serializing message body", exchange, (Throwable)e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

