/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.irc.IrcChannel;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.component.irc.IrcMessage;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrcConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(IrcConsumer.class);
    private final IrcConfiguration configuration;
    private final IrcEndpoint endpoint;
    private final IRCConnection connection;
    private IRCEventAdapter listener = new FilteredIRCEventAdapter();

    public IrcConsumer(IrcEndpoint endpoint, Processor processor, IRCConnection connection) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.connection = connection;
        this.configuration = endpoint.getConfiguration();
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            for (IrcChannel channel : this.endpoint.getConfiguration().getChannelList()) {
                LOG.debug("Parting: {}", (Object)channel);
                this.connection.doPart(channel.getName());
            }
            this.connection.removeIRCEventListener((IRCEventListener)this.listener);
        }
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = this.getListener();
        this.connection.addIRCEventListener((IRCEventListener)this.listener);
        LOG.debug("Sleeping for {} seconds before sending commands.", (Object)(this.configuration.getCommandTimeout() / 1000L));
        try {
            Thread.sleep(this.configuration.getCommandTimeout());
        }
        catch (InterruptedException ex) {
            LOG.info("Interrupted while sleeping before sending commands");
            Thread.currentThread().interrupt();
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getNickPassword())) {
            LOG.debug("Identifying and enforcing nick with NickServ.");
            this.connection.doPrivmsg("nickserv", "identify " + this.configuration.getNickPassword());
            this.connection.doPrivmsg("nickserv", "set enforce on");
        }
        this.endpoint.joinChannels();
    }

    private Exchange createOnPrivmsgExchange(String target, IRCUser user, String msg) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "PRIVMSG", target, user, msg);
        exchange.setIn((Message)im);
        return exchange;
    }

    private Exchange createOnNickExchange(IRCUser user, String newNick) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "NICK", user, newNick);
        exchange.setIn((Message)im);
        return exchange;
    }

    private Exchange createOnQuitExchange(IRCUser user, String msg) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "QUIT", user, msg);
        exchange.setIn((Message)im);
        return exchange;
    }

    private Exchange createOnJoinExchange(String channel, IRCUser user) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "JOIN", channel, user);
        exchange.setIn((Message)im);
        return exchange;
    }

    private Exchange createOnKickExchange(String channel, IRCUser user, String whoWasKickedNick, String msg) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "KICK", channel, user, whoWasKickedNick, msg);
        exchange.setIn((Message)im);
        return exchange;
    }

    private Exchange createOnModeExchange(String channel, IRCUser user, IRCModeParser modeParser) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "MODE", channel, user, modeParser.getLine());
        exchange.setIn((Message)im);
        return exchange;
    }

    private Exchange createOnPartExchange(String channel, IRCUser user, String msg) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "PART", channel, user, msg);
        exchange.setIn((Message)im);
        return exchange;
    }

    private Exchange createOnReplyExchange(int num, String value, String msg) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "REPLY", num, value, msg);
        exchange.setIn((Message)im);
        return exchange;
    }

    private Exchange createOnTopicExchange(String channel, IRCUser user, String topic) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        IrcMessage im = new IrcMessage(this.endpoint.getCamelContext(), "TOPIC", channel, user, topic);
        exchange.setIn((Message)im);
        return exchange;
    }

    public IRCConnection getConnection() {
        return this.connection;
    }

    public IRCEventAdapter getListener() {
        return this.listener;
    }

    public void setListener(IRCEventAdapter listener) {
        this.listener = listener;
    }

    class FilteredIRCEventAdapter
    extends IRCEventAdapter {
        FilteredIRCEventAdapter() {
        }

        public void onNick(IRCUser user, String newNick) {
            if (IrcConsumer.this.configuration.isOnNick()) {
                Exchange exchange = IrcConsumer.this.createOnNickExchange(user, newNick);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onQuit(IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnQuit()) {
                Exchange exchange = IrcConsumer.this.createOnQuitExchange(user, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onJoin(String channel, IRCUser user) {
            if (IrcConsumer.this.configuration.isOnJoin()) {
                Exchange exchange = IrcConsumer.this.createOnJoinExchange(channel, user);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onKick(String channel, IRCUser user, String passiveNick, String msg) {
            if (passiveNick.equals(IrcConsumer.this.connection.getNick()) && IrcConsumer.this.configuration.isAutoRejoin()) {
                IrcConsumer.this.endpoint.joinChannel(channel);
            }
            if (IrcConsumer.this.configuration.isOnKick()) {
                Exchange exchange = IrcConsumer.this.createOnKickExchange(channel, user, passiveNick, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onMode(String channel, IRCUser user, IRCModeParser modeParser) {
            if (IrcConsumer.this.configuration.isOnMode()) {
                Exchange exchange = IrcConsumer.this.createOnModeExchange(channel, user, modeParser);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onPart(String channel, IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnPart()) {
                Exchange exchange = IrcConsumer.this.createOnPartExchange(channel, user, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onReply(int num, String value, String msg) {
            if (IrcConsumer.this.configuration.isOnReply()) {
                Exchange exchange = IrcConsumer.this.createOnReplyExchange(num, value, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onTopic(String channel, IRCUser user, String topic) {
            if (IrcConsumer.this.configuration.isOnTopic()) {
                Exchange exchange = IrcConsumer.this.createOnTopicExchange(channel, user, topic);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onPrivmsg(String target, IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnPrivmsg()) {
                Exchange exchange = IrcConsumer.this.createOnPrivmsgExchange(target, user, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onError(int num, String msg) {
        }
    }
}

