/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.util.xml.BytesSource;
import org.apache.camel.util.xml.StringSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XmlConverterLoader
implements TypeConverterLoader {
    private volatile XmlConverter xmlConverter;

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        XmlConverterLoader.addTypeConverter(registry, byte[].class, Source.class, false, (type, exchange, value) -> this.getXmlConverter().toByteArray((Source)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, InputStream.class, DOMSource.class, false, (type, exchange, value) -> this.getXmlConverter().toInputStream((DOMSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, InputStream.class, Document.class, false, (type, exchange, value) -> this.getXmlConverter().toInputStream((Document)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Reader.class, Source.class, false, (type, exchange, value) -> this.getXmlConverter().toReaderFromSource((Source)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Boolean.class, NodeList.class, false, (type, exchange, value) -> this.getXmlConverter().toBoolean((NodeList)value));
        XmlConverterLoader.addTypeConverter(registry, String.class, Source.class, false, (type, exchange, value) -> this.getXmlConverter().toString((Source)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, String.class, Node.class, false, (type, exchange, value) -> this.getXmlConverter().toString((Node)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Source.class, String.class, false, (type, exchange, value) -> this.getXmlConverter().toSource((String)value));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, byte[].class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSource((byte[])value));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, File.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSource((File)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, InputStream.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSource((InputStream)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, String.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSource((String)value));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, SAXSource.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSourceFromSAX((SAXSource)value));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, StAXSource.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSourceFromStAX((StAXSource)value));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, StreamSource.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSourceFromStream((StreamSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, Source.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSource((Source)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, Document.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSource((Document)value));
        XmlConverterLoader.addTypeConverter(registry, DOMSource.class, Node.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMSource((Node)value));
        XmlConverterLoader.addTypeConverter(registry, SAXSource.class, byte[].class, false, (type, exchange, value) -> this.getXmlConverter().toSAXSource((byte[])value, exchange));
        XmlConverterLoader.addTypeConverter(registry, SAXSource.class, File.class, false, (type, exchange, value) -> this.getXmlConverter().toSAXSource((File)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, SAXSource.class, InputStream.class, false, (type, exchange, value) -> this.getXmlConverter().toSAXSource((InputStream)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, SAXSource.class, String.class, false, (type, exchange, value) -> this.getXmlConverter().toSAXSource((String)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, SAXSource.class, DOMSource.class, false, (type, exchange, value) -> this.getXmlConverter().toSAXSourceFromDOM((DOMSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, SAXSource.class, StAXSource.class, false, (type, exchange, value) -> this.getXmlConverter().toSAXSourceFromStAX((StAXSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, SAXSource.class, StreamSource.class, false, (type, exchange, value) -> this.getXmlConverter().toSAXSourceFromStream((StreamSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, SAXSource.class, Source.class, false, (type, exchange, value) -> this.getXmlConverter().toSAXSource((Source)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StAXSource.class, byte[].class, false, (type, exchange, value) -> this.getXmlConverter().toStAXSource((byte[])value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StAXSource.class, File.class, false, (type, exchange, value) -> this.getXmlConverter().toStAXSource((File)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StAXSource.class, InputStream.class, false, (type, exchange, value) -> this.getXmlConverter().toStAXSource((InputStream)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StAXSource.class, String.class, false, (type, exchange, value) -> this.getXmlConverter().toStAXSource((String)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, byte[].class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSource((byte[])value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, File.class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSource((File)value));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, InputStream.class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSource((InputStream)value));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, Reader.class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSource((Reader)value));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, ByteBuffer.class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSource((ByteBuffer)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, DOMSource.class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSourceFromDOM((DOMSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, SAXSource.class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSourceFromSAX((SAXSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, StAXSource.class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSourceFromStAX((StAXSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, StreamSource.class, Source.class, false, (type, exchange, value) -> this.getXmlConverter().toStreamSource((Source)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, BytesSource.class, byte[].class, false, (type, exchange, value) -> this.getXmlConverter().toBytesSource((byte[])value));
        XmlConverterLoader.addTypeConverter(registry, StringSource.class, String.class, false, (type, exchange, value) -> this.getXmlConverter().toStringSource((String)value));
        XmlConverterLoader.addTypeConverter(registry, Document.class, byte[].class, false, (type, exchange, value) -> this.getXmlConverter().toDOMDocument((byte[])value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Document.class, File.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMDocument((File)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Document.class, InputStream.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMDocument((InputStream)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Document.class, Reader.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMDocument((Reader)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Document.class, String.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMDocument((String)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Document.class, Source.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMDocument((Source)value));
        XmlConverterLoader.addTypeConverter(registry, Document.class, Node.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMDocument((Node)value));
        XmlConverterLoader.addTypeConverter(registry, Document.class, NodeList.class, true, (type, exchange, value) -> this.getXmlConverter().toDOMDocumentFromSingleNodeList((NodeList)value));
        XmlConverterLoader.addTypeConverter(registry, Document.class, InputSource.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMDocument((InputSource)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, Element.class, Source.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMElement((Source)value));
        XmlConverterLoader.addTypeConverter(registry, Element.class, Node.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMElement((Node)value));
        XmlConverterLoader.addTypeConverter(registry, Node.class, SAXSource.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMNodeFromSAX((SAXSource)value));
        XmlConverterLoader.addTypeConverter(registry, Node.class, StAXSource.class, false, (type, exchange, value) -> this.getXmlConverter().toDOMNodeFromStAX((StAXSource)value));
        XmlConverterLoader.addTypeConverter(registry, Node.class, Source.class, true, (type, exchange, value) -> this.getXmlConverter().toDOMNode((Source)value));
        XmlConverterLoader.addTypeConverter(registry, Node.class, NodeList.class, true, (type, exchange, value) -> this.getXmlConverter().toDOMNodeFromSingleNodeList((NodeList)value));
        XmlConverterLoader.addTypeConverter(registry, InputSource.class, File.class, false, (type, exchange, value) -> this.getXmlConverter().toInputSource((File)value, exchange));
        XmlConverterLoader.addTypeConverter(registry, InputSource.class, InputStream.class, false, (type, exchange, value) -> this.getXmlConverter().toInputSource((InputStream)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlConverter getXmlConverter() {
        if (this.xmlConverter == null) {
            XmlConverterLoader xmlConverterLoader = this;
            synchronized (xmlConverterLoader) {
                if (this.xmlConverter == null) {
                    this.xmlConverter = new XmlConverter();
                }
            }
        }
        return this.xmlConverter;
    }
}

