/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.workitem;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.ExchangeBuilder;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.runtime.Cacheable;

public abstract class AbstractCamelCommand
implements Command,
Cacheable {
    public ExecutionResults execute(CommandContext ctx) throws Exception {
        Exchange inExchange;
        WorkItem workItem = (WorkItem)ctx.getData("workItem");
        String camelEndpointId = (String)workItem.getParameter("CamelEndpointId");
        String camelUri = "direct:" + camelEndpointId;
        ProducerTemplate producerTemplate = this.getProducerTemplate(ctx);
        Exchange outExchange = producerTemplate.send(camelUri, inExchange = ExchangeBuilder.anExchange((CamelContext)producerTemplate.getCamelContext()).withBody((Object)workItem).build());
        if (outExchange.getException() != null) {
            throw outExchange.getException();
        }
        Message outMessage = outExchange.getOut();
        ExecutionResults results = new ExecutionResults();
        Object response = outMessage.getBody();
        results.setData("Response", response);
        results.setData("Message", (Object)outMessage);
        return results;
    }

    protected abstract ProducerTemplate getProducerTemplate(CommandContext var1);
}

