/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import com.google.common.base.Predicate;
import java.util.Set;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.jclouds.JcloudsComputeEndpoint;
import org.apache.camel.component.jclouds.JcloudsEndpoint;
import org.apache.camel.component.jclouds.JcloudsProducer;
import org.apache.camel.util.ObjectHelper;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.NodeMetadataImpl;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;

public class JcloudsComputeProducer
extends JcloudsProducer {
    private final ComputeService computeService;

    public JcloudsComputeProducer(JcloudsEndpoint endpoint, ComputeService computeService) {
        super(endpoint);
        this.computeService = computeService;
    }

    public JcloudsComputeEndpoint getEndpoint() {
        return (JcloudsComputeEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = this.getOperation(exchange);
        if (operation == null) {
            throw new CamelExchangeException("Operation must be specified in the endpoint URI or as a property on the exchange.", exchange);
        }
        if ("CamelJcloudsListNodes".equals(operation)) {
            this.listNodes(exchange);
        } else if ("CamelJcloudsListImages".equals(operation)) {
            this.listImages(exchange);
        } else if ("CamelJcloudsListHardware".equals(operation)) {
            this.listHardware(exchange);
        } else if ("CamelJcloudsRunScript".equals(operation)) {
            this.runScriptOnNode(exchange);
        } else if ("CamelJcloudsCreateNode".equals(operation)) {
            this.createNode(exchange);
        } else if ("CamelJcloudsDestroyNode".equals(operation)) {
            this.destroyNode(exchange);
        } else if ("CamelJcloudsRebootNode".equals(operation)) {
            this.rebootNode(exchange);
        } else if ("CamelJcloudsSuspendNode".equals(operation)) {
            this.suspendNode(exchange);
        } else if ("CamelJcloudsResumeNode".equals(operation)) {
            this.resumeNode(exchange);
        }
    }

    protected void createNode(Exchange exchange) throws CamelException {
        String group = this.getGroup(exchange);
        String imageId = this.getImageId(exchange);
        String locationId = this.getLocationId(exchange);
        String hardwareId = this.getHardwareId(exchange);
        if (ObjectHelper.isEmpty((String)group)) {
            throw new CamelExchangeException("Group must be specific in the URI or as exchange property for the destroy node operation.", exchange);
        }
        TemplateBuilder builder = this.computeService.templateBuilder();
        builder.any();
        if (ObjectHelper.isNotEmpty((String)locationId)) {
            builder.locationId(locationId);
        }
        if (ObjectHelper.isNotEmpty((String)imageId)) {
            builder.imageId(imageId);
        }
        if (ObjectHelper.isNotEmpty((String)hardwareId)) {
            builder.hardwareId(hardwareId);
        }
        try {
            Set nodeMetadatas = this.computeService.createNodesInGroup(group, 1, builder.build());
            exchange.getMessage().setBody((Object)nodeMetadatas);
            exchange.getMessage().setHeaders(exchange.getIn().getHeaders());
        }
        catch (RunNodesException e) {
            throw new CamelExchangeException("Error creating jclouds node.", exchange, (Throwable)e);
        }
    }

    protected void runScriptOnNode(Exchange exchange) throws CamelException {
        String script = (String)exchange.getIn().getBody(String.class);
        String nodeId = this.getNodeId(exchange);
        String user = this.getUser(exchange);
        LoginCredentials credentials = null;
        if (ObjectHelper.isNotEmpty((String)user)) {
            credentials = LoginCredentials.builder().user(user).build();
        }
        ExecResponse execResponse = null;
        execResponse = credentials == null ? this.computeService.runScriptOnNode(nodeId, script) : this.computeService.runScriptOnNode(nodeId, script, RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(false));
        if (execResponse == null) {
            throw new CamelExchangeException("Failed to receive response for run script operation on node: " + nodeId + " using script: " + script, exchange);
        }
        exchange.setProperty("CamelJcloudsRunScriptError", (Object)execResponse.getError());
        exchange.setProperty("CamelJcloudsRunScriptErrorCode", (Object)execResponse.getExitStatus());
        exchange.getMessage().setBody((Object)execResponse.getOutput());
    }

    protected void destroyNode(Exchange exchange) {
        Predicate<NodeMetadata> predicate = this.getNodePredicate(exchange);
        this.computeService.destroyNodesMatching(predicate);
    }

    protected void listNodes(Exchange exchange) {
        Predicate<ComputeMetadata> predicate = this.getComputePredicate(exchange);
        Set computeMetadatas = this.computeService.listNodesDetailsMatching(predicate);
        exchange.getMessage().setBody((Object)computeMetadatas);
    }

    protected void listImages(Exchange exchange) {
        Set images = this.computeService.listImages();
        exchange.getMessage().setBody((Object)images);
    }

    protected void listHardware(Exchange exchange) {
        Set hardwareProfiles = this.computeService.listHardwareProfiles();
        exchange.getMessage().setBody((Object)hardwareProfiles);
    }

    protected void rebootNode(Exchange exchange) {
        Predicate<NodeMetadata> predicate = this.getNodePredicate(exchange);
        this.computeService.rebootNodesMatching(predicate);
    }

    protected void suspendNode(Exchange exchange) {
        Predicate<NodeMetadata> predicate = this.getNodePredicate(exchange);
        this.computeService.suspendNodesMatching(predicate);
    }

    protected void resumeNode(Exchange exchange) {
        Predicate<NodeMetadata> predicate = this.getNodePredicate(exchange);
        this.computeService.resumeNodesMatching(predicate);
    }

    public Predicate<ComputeMetadata> getComputePredicate(final Exchange exchange) {
        final String nodeId = this.getNodeId(exchange);
        Predicate<ComputeMetadata> predicate = new Predicate<ComputeMetadata>(){

            public boolean apply(ComputeMetadata metadata) {
                Predicate<NodeMetadata> nodeMetadataPredicate;
                if (nodeId != null && !nodeId.equals(metadata.getId())) {
                    return false;
                }
                return !(metadata instanceof NodeMetadataImpl) || (nodeMetadataPredicate = JcloudsComputeProducer.this.getNodePredicate(exchange)).apply((Object)((NodeMetadataImpl)metadata));
            }
        };
        return predicate;
    }

    public Predicate<NodeMetadata> getNodePredicate(Exchange exchange) {
        final String nodeId = this.getNodeId(exchange);
        final String imageId = this.getImageId(exchange);
        final String group = this.getGroup(exchange);
        final NodeMetadata.Status queryState = this.getNodeState(exchange);
        Predicate<NodeMetadata> predicate = new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata metadata) {
                if (nodeId != null && !nodeId.equals(metadata.getId())) {
                    return false;
                }
                if (imageId != null && !imageId.equals(metadata.getImageId())) {
                    return false;
                }
                if (queryState != null && !queryState.equals((Object)metadata.getStatus())) {
                    return false;
                }
                return group == null || group.equals(metadata.getGroup());
            }
        };
        return predicate;
    }

    public String getOperation(Exchange exchange) {
        String operation = this.getEndpoint().getOperation();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsOperation"))) {
            operation = (String)exchange.getIn().getHeader("CamelJcloudsOperation", String.class);
        }
        return operation;
    }

    public NodeMetadata.Status getNodeState(Exchange exchange) {
        Object nodeState = null;
        String state = this.getEndpoint().getNodeState();
        if (ObjectHelper.isNotEmpty((String)state)) {
            nodeState = NodeMetadata.Status.valueOf((String)state);
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsNodeState"))) {
            Object stateHeader = exchange.getIn().getHeader("CamelJcloudsNodeState");
            nodeState = stateHeader == null ? null : (stateHeader instanceof NodeMetadata.Status ? (NodeMetadata.Status)stateHeader : NodeMetadata.Status.valueOf((String)String.valueOf(stateHeader)));
        }
        return nodeState;
    }

    protected String getImageId(Exchange exchange) {
        String imageId = this.getEndpoint().getImageId();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsImageId"))) {
            imageId = (String)exchange.getIn().getHeader("CamelJcloudsImageId", String.class);
        }
        return imageId;
    }

    protected String getHardwareId(Exchange exchange) {
        String hardwareId = this.getEndpoint().getHardwareId();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsHardwareId"))) {
            hardwareId = (String)exchange.getIn().getHeader("CamelJcloudsHardwareId", String.class);
        }
        return hardwareId;
    }

    protected String getLocationId(Exchange exchange) {
        String locationId = this.getEndpoint().getLocationId();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsLocationId"))) {
            locationId = (String)exchange.getIn().getHeader("CamelJcloudsLocationId", String.class);
        }
        return locationId;
    }

    protected String getNodeId(Exchange exchange) {
        String nodeId = this.getEndpoint().getNodeId();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsNodeId"))) {
            nodeId = (String)exchange.getIn().getHeader("CamelJcloudsNodeId", String.class);
        }
        return nodeId;
    }

    protected String getGroup(Exchange exchange) {
        String group = this.getEndpoint().getGroup();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsGroup"))) {
            group = (String)exchange.getIn().getHeader("CamelJcloudsGroup", String.class);
        }
        return group;
    }

    protected String getUser(Exchange exchange) {
        String user = this.getEndpoint().getUser();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsUser"))) {
            user = (String)exchange.getIn().getHeader("CamelJcloudsUser", String.class);
        }
        return user;
    }
}

