/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400ConnectionPool;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jt400.Jt400DataQueueEndpoint;
import org.apache.camel.component.jt400.Jt400PgmEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.EndpointHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jt400Component
extends DefaultComponent {
    static final String CONNECTION_POOL = "connectionPool";
    private static final Logger LOG = LoggerFactory.getLogger(Jt400Component.class);
    private static final String DATA_QUEUE = "DTAQ";
    private static final String PGM = "PGM";
    private AS400ConnectionPool connectionPool;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> properties) throws Exception {
        AS400ConnectionPool connectionPool;
        String type = remaining.substring(remaining.lastIndexOf(".") + 1).toUpperCase();
        if (properties.containsKey(CONNECTION_POOL)) {
            LOG.trace("AS400ConnectionPool instance specified in the URI - will look it up.");
            String poolId = properties.remove(CONNECTION_POOL).toString();
            connectionPool = (AS400ConnectionPool)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)poolId, AS400ConnectionPool.class, (boolean)true);
        } else {
            LOG.trace("No AS400ConnectionPool instance specified in the URI - one will be provided.");
            connectionPool = this.getConnectionPool();
        }
        if (DATA_QUEUE.equals(type)) {
            return new Jt400DataQueueEndpoint(uri, this, connectionPool);
        }
        if (PGM.equals(type)) {
            return new Jt400PgmEndpoint(uri, this, connectionPool);
        }
        throw new CamelException(String.format("AS/400 Object type %s is not supported", type));
    }

    public synchronized AS400ConnectionPool getConnectionPool() {
        if (this.connectionPool == null) {
            LOG.info("Instantiating the default connection pool ...");
            this.connectionPool = new AS400ConnectionPool();
        }
        return this.connectionPool;
    }

    public void setConnectionPool(AS400ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.connectionPool != null) {
            LOG.info("Shutting down the default connection pool " + this.connectionPool + " ...");
            this.connectionPool.close();
            this.connectionPool = null;
        }
    }
}

