/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Set;
import org.apache.camel.component.kafka.consumer.support.KafkaRecordProcessor;
import org.apache.camel.component.kafka.consumer.support.ResumeStrategy;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetResumeStrategy
implements ResumeStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetResumeStrategy.class);
    private final StateRepository<String, String> offsetRepository;

    public OffsetResumeStrategy(StateRepository<String, String> offsetRepository) {
        this.offsetRepository = offsetRepository;
    }

    private void resumeFromOffset(KafkaConsumer<?, ?> consumer, TopicPartition topicPartition, String offsetState) {
        long offset = KafkaRecordProcessor.deserializeOffsetValue(offsetState) + 1L;
        LOG.debug("Resuming partition {} from offset {} from state", (Object)topicPartition.partition(), (Object)offset);
        consumer.seek(topicPartition, offset);
    }

    @Override
    public void resume(KafkaConsumer<?, ?> consumer) {
        Set assignments = consumer.assignment();
        for (TopicPartition topicPartition : assignments) {
            String offsetState = (String)this.offsetRepository.getState((Object)KafkaRecordProcessor.serializeOffsetKey(topicPartition));
            if (offsetState == null || offsetState.isEmpty()) continue;
            this.resumeFromOffset(consumer, topicPartition, offsetState);
        }
    }
}

